/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.command;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveMatchCommand
extends Command {
    protected final ArrayList<SimpleMatch> toRemove;
    protected final SimpleMatchList matchesList;

    public RemoveMatchCommand(SimpleMatchList matchesList, Collection<SimpleMatch> toRemove) {
        super(MainApplication.getLayerManager().getEditDataSet());
        this.toRemove = new ArrayList<SimpleMatch>(toRemove);
        this.matchesList = matchesList;
    }

    public boolean executeCommand() {
        this.matchesList.beginUpdate();
        try {
            this.matchesList.removeAll(this.toRemove);
        }
        finally {
            this.matchesList.endUpdate();
        }
        return true;
    }

    public void undoCommand() {
        this.matchesList.beginUpdate();
        try {
            this.matchesList.addAll(this.toRemove);
        }
        finally {
            this.matchesList.endUpdate();
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.trn((String)"Delete {0} conflation match", (String)"Delete {0} conflation matches", (long)this.toRemove.size(), (Object[])new Object[]{this.toRemove.size()});
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"dialogs", (String)"delete");
    }
}

