/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchList;
import org.openstreetmap.josm.plugins.conflation.UnmatchedObjectListModel;
import org.openstreetmap.josm.plugins.conflation.command.RemoveMatchCommand;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MoveMatchToUnmatchedCommand
extends RemoveMatchCommand {
    protected final UnmatchedObjectListModel referenceOnlyListModel;
    protected final UnmatchedObjectListModel subjectOnlyListModel;

    public MoveMatchToUnmatchedCommand(SimpleMatchList matcheList, Collection<SimpleMatch> toRemove, UnmatchedObjectListModel referenceOnlyListModel, UnmatchedObjectListModel subjectOnlyListModel) {
        super(matcheList, toRemove);
        this.referenceOnlyListModel = referenceOnlyListModel;
        this.subjectOnlyListModel = subjectOnlyListModel;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.referenceOnlyListModel.beginUpdate();
        this.subjectOnlyListModel.beginUpdate();
        try {
            for (SimpleMatch match : this.toRemove) {
                this.referenceOnlyListModel.addElement(match.getReferenceObject());
                this.subjectOnlyListModel.addElement(match.getSubjectObject());
            }
        }
        finally {
            this.referenceOnlyListModel.endUpdate();
            this.subjectOnlyListModel.endUpdate();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        this.referenceOnlyListModel.beginUpdate();
        this.subjectOnlyListModel.beginUpdate();
        try {
            for (SimpleMatch match : this.toRemove) {
                this.referenceOnlyListModel.removeElement(match.getReferenceObject());
                this.subjectOnlyListModel.removeElement(match.getSubjectObject());
            }
        }
        finally {
            this.referenceOnlyListModel.endUpdate();
            this.subjectOnlyListModel.endUpdate();
        }
        super.undoCommand();
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn((String)"Moved {0} conflation match to unmatched list", (String)"Moved {0} conflation matches to unmatched list", (long)this.toRemove.size(), (Object[])new Object[]{this.toRemove.size()});
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"dialogs", (String)"delete");
    }
}

