/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.plugins.conflation.UnmatchedObjectListModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflateUnmatchedObjectCommand
extends Command {
    private final AddPrimitivesCommand addPrimitivesCommand;
    private final Collection<OsmPrimitive> unmatchedObjects;
    private final UnmatchedObjectListModel listModel;

    public ConflateUnmatchedObjectCommand(OsmDataLayer sourceDataLayer, DataSet targetDataSet, Collection<OsmPrimitive> unmatchedObjects, UnmatchedObjectListModel listModel) {
        super(targetDataSet);
        this.unmatchedObjects = unmatchedObjects;
        this.listModel = listModel;
        List<PrimitiveData> newObjects = ConflationUtils.copyObjects(sourceDataLayer.getDataSet(), unmatchedObjects);
        this.addPrimitivesCommand = new AddPrimitivesCommand(newObjects, newObjects, targetDataSet);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        this.addPrimitivesCommand.fillModifiedData(modified, deleted, added);
    }

    public String getDescriptionText() {
        int size = this.unmatchedObjects.size();
        return I18n.trn((String)"Added {0} object to subject layer", (String)"Added {0} objects to subject layer", (long)size, (Object[])new Object[]{size});
    }

    public boolean executeCommand() {
        this.listModel.beginUpdate();
        try {
            if (!this.addPrimitivesCommand.executeCommand()) {
                boolean bl = false;
                return bl;
            }
            this.listModel.removeAll(this.unmatchedObjects);
        }
        finally {
            this.listModel.endUpdate();
        }
        return true;
    }

    public void undoCommand() {
        this.listModel.beginUpdate();
        try {
            this.addPrimitivesCommand.undoCommand();
            this.listModel.addAll(this.unmatchedObjects);
        }
        finally {
            this.listModel.endUpdate();
        }
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"dialogs", (String)"conflation");
    }

    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<OsmPrimitive> prims = new HashSet<OsmPrimitive>();
        prims.addAll(this.addPrimitivesCommand.getParticipatingPrimitives());
        prims.addAll(this.unmatchedObjects);
        return prims;
    }

    public Collection<PseudoCommand> getChildren() {
        return Arrays.asList(this.addPrimitivesCommand);
    }
}

