/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.command;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchList;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.plugins.conflation.command.RemoveMatchCommand;
import org.openstreetmap.josm.plugins.conflation.command.SetSelectedCommand;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryCommand;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryException;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class ConflateMatchCommand
extends Command {
    private final SimpleMatch match;
    private final SimpleMatchList matchesList;
    private final SimpleMatchSettings settings;
    private SequenceCommand command;
    private boolean isBuilt;

    public ConflateMatchCommand(SimpleMatch match, SimpleMatchList matchesList, SimpleMatchSettings settings) {
        super(settings.subjectDataSet);
        this.match = match;
        this.matchesList = matchesList;
        this.settings = settings;
    }

    public boolean executeCommand() {
        if (!this.isBuilt) {
            this.isBuilt = true;
            this.command = this.buildCommand();
        }
        return this.command != null ? this.command.executeCommand() : false;
    }

    public void undoCommand() {
        if (this.command != null) {
            this.command.undoCommand();
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        if (this.command != null) {
            this.command.fillModifiedData(modified, deleted, added);
        }
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Conflate object pair", (Object[])new Object[0]);
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"dialogs", (String)"conflation");
    }

    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        if (this.command != null) {
            return this.command.getParticipatingPrimitives();
        }
        return Arrays.asList(new OsmPrimitive[0]);
    }

    public Collection<PseudoCommand> getChildren() {
        if (this.command != null) {
            return this.command.getChildren();
        }
        return Arrays.asList(new PseudoCommand[0]);
    }

    private SequenceCommand buildCommand() {
        List<Command> list;
        List<Command> list2 = list = this.settings.isReplacingGeometry ? ConflateMatchCommand.buildCopyAndReplaceGeometryCommand(this.match, this.settings) : ConflateMatchCommand.buildTagMergingCommand(this.match, this.settings);
        if (list == null) {
            return null;
        }
        list.add(new RemoveMatchCommand(this.matchesList, Arrays.asList(this.match)));
        return new SequenceCommand("", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Command> buildCopyAndReplaceGeometryCommand(SimpleMatch match, SimpleMatchSettings settings) {
        OsmPrimitive referenceObject = match.getReferenceObject();
        OsmPrimitive subjectObject = match.getSubjectObject();
        TagCollection tagCollection = match.getMergingTagCollection(settings);
        ArrayList<Command> commands = new ArrayList<Command>(3);
        if (settings.subjectLayer != settings.referenceLayer) {
            List<Command> copyPrimitiveCommand = ConflateMatchCommand.buildCopyPrimitiveCommand(referenceObject, settings.subjectDataSet);
            commands.addAll(copyPrimitiveCommand);
            if (!copyPrimitiveCommand.get(0).executeCommand()) {
                return null;
            }
            try {
                commands.add(ConflateMatchCommand.buildReplaceGeometryCommand(subjectObject, subjectObject.getDataSet().getPrimitiveById(referenceObject.getPrimitiveId()), tagCollection));
            }
            finally {
                copyPrimitiveCommand.get(0).undoCommand();
            }
        } else {
            commands.add(ConflateMatchCommand.buildReplaceGeometryCommand(subjectObject, referenceObject, tagCollection));
        }
        if (commands.get(commands.size() - 1) == null) {
            return null;
        }
        Stream.concat(referenceObject.getKeys().keySet().stream(), subjectObject.getKeys().keySet().stream()).filter(key -> !tagCollection.hasTagsFor(key)).forEach(key -> {
            commands.add((Command)new ChangePropertyCommand(referenceObject, key, null));
            commands.add((Command)new ChangePropertyCommand(subjectObject, key, null));
        });
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Command buildReplaceGeometryCommand(OsmPrimitive subjectObject, OsmPrimitive referenceObject, TagCollection tagCollection) {
        TagMap savedReferenceTags = ConflateMatchCommand.saveAndRemoveTagsNotInCollection(referenceObject, tagCollection);
        TagMap savedSubjectTags = ConflateMatchCommand.saveAndRemoveTagsNotInCollection(subjectObject, tagCollection);
        ReplaceGeometryCommand command = null;
        try {
            command = ReplaceGeometryUtils.buildReplaceCommand((OsmPrimitive)subjectObject, (OsmPrimitive)referenceObject);
        }
        catch (ReplaceGeometryException ex) {
            AutoScaleAction.zoomTo(Arrays.asList(subjectObject, referenceObject));
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), ex.getMessage(), I18n.tr((String)"Cannot replace geometry.", (Object[])new Object[0]), 1);
        }
        finally {
            referenceObject.setKeys(savedReferenceTags);
            subjectObject.setKeys(savedSubjectTags);
        }
        return command;
    }

    public static List<Command> buildCopyPrimitiveCommand(OsmPrimitive referenceObject, DataSet data) {
        List<PrimitiveData> newObjects = ConflationUtils.copyObjects(referenceObject.getDataSet(), referenceObject);
        ArrayList<Command> commands = new ArrayList<Command>(2);
        commands.add((Command)new AddPrimitivesCommand(newObjects, null, data));
        commands.add(new SetSelectedCommand(data, newObjects));
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Command> buildTagMergingCommand(SimpleMatch match, SimpleMatchSettings settings) {
        HashMap<Relation, RelationData> savedRelationsData = ConflateMatchCommand.saveAndRemoveRelationMembersFor(match.getReferenceObject());
        ConflateMatchCommand.saveAndRemoveRelationMembersFor(match.getSubjectObject()).forEach(savedRelationsData::putIfAbsent);
        try {
            List list = CombinePrimitiveResolverDialog.launchIfNecessary((TagCollection)match.getMergingTagCollection(settings), Arrays.asList(match.getReferenceObject(), match.getSubjectObject()), Collections.singleton(match.getSubjectObject()));
            return list;
        }
        catch (UserCancelException e) {
            List<Command> list = null;
            return list;
        }
        finally {
            ConflateMatchCommand.restoreRelationsData(savedRelationsData);
        }
    }

    private static HashMap<Relation, RelationData> saveAndRemoveRelationMembersFor(OsmPrimitive primitive) {
        HashMap<Relation, RelationData> savedData = new HashMap<Relation, RelationData>();
        for (Relation r : Utils.filteredCollection((Collection)primitive.getReferrers(), Relation.class)) {
            savedData.put(r, r.save());
            r.removeMembersFor(primitive);
        }
        return savedData;
    }

    private static void restoreRelationsData(HashMap<Relation, RelationData> savedData) {
        savedData.entrySet().stream().forEach(entry -> ((Relation)entry.getKey()).load((PrimitiveData)entry.getValue()));
    }

    private static TagMap saveAndRemoveTagsNotInCollection(OsmPrimitive primitive, TagCollection tagCollection) {
        TagMap savedTags = primitive.getKeys();
        for (Tag tag : savedTags.getTags()) {
            if (tagCollection.contains(tag)) continue;
            primitive.remove(tag.getKey());
        }
        return savedTags;
    }
}

