/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractListModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class UnmatchedObjectListModel
extends AbstractListModel<OsmPrimitive> {
    private ArrayList<OsmPrimitive> list = new ArrayList();
    private int updateCount = 0;
    private boolean updateHasChanged = false;
    private int sizeBeforeChange;

    public void clear() {
        int size = this.list.size();
        if (size > 0) {
            this.list.clear();
            if (this.shouldFireEvent()) {
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public OsmPrimitive getElementAt(int index) {
        return this.list.get(index);
    }

    public int indexOf(OsmPrimitive item) {
        int index = Collections.binarySearch(this.list, item);
        if (index < -1) {
            index = -1;
        }
        return index;
    }

    public boolean addElement(OsmPrimitive element) {
        int index = Collections.binarySearch(this.list, element);
        if (index < 0) {
            index = -index - 1;
            this.list.add(index, element);
            if (this.shouldFireEvent()) {
                this.fireIntervalAdded(this, index, index);
            }
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<OsmPrimitive> objects) {
        if (this.list.size() == 0 && objects.size() > 0) {
            this.list.addAll(objects);
            Collections.sort(this.list);
            if (this.shouldFireEvent()) {
                this.fireIntervalAdded(this, 0, this.list.size() - 1);
            }
            return true;
        }
        boolean changed = false;
        for (OsmPrimitive p : objects) {
            changed = this.addElement(p) || changed;
        }
        return changed;
    }

    public boolean removeElement(OsmPrimitive element) {
        int index = Collections.binarySearch(this.list, element);
        if (index >= 0) {
            this.list.remove(index);
            if (this.shouldFireEvent()) {
                this.fireIntervalRemoved(this, index, index);
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<OsmPrimitive> objects) {
        boolean changed = false;
        for (OsmPrimitive p : objects) {
            changed = this.removeElement(p) || changed;
        }
        return changed;
    }

    protected boolean shouldFireEvent() {
        if (this.updateCount > 0) {
            this.updateHasChanged = true;
            return false;
        }
        return true;
    }

    public void beginUpdate() {
        if (this.updateCount == 0) {
            this.sizeBeforeChange = this.list.size();
        }
        ++this.updateCount;
    }

    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            if (this.updateCount == 0 && this.updateHasChanged) {
                this.updateHasChanged = false;
                if (this.sizeBeforeChange > this.getSize()) {
                    this.fireIntervalRemoved(this, this.getSize(), this.sizeBeforeChange - 1);
                } else if (this.getSize() > this.sizeBeforeChange) {
                    this.fireIntervalAdded(this, this.sizeBeforeChange, this.getSize() - 1);
                }
                this.fireContentsChanged(this, 0, Integer.min(this.sizeBeforeChange, this.getSize()) - 1);
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }
}

