/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchList;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchListListener;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.tools.I18n;

class SimpleMatchesTableModel
extends AbstractTableModel
implements SimpleMatchListListener {
    private SimpleMatchList matches = null;
    private SimpleMatchSettings settings = null;
    private static final String[] columnNames = new String[]{I18n.tr((String)"Reference", (Object[])new Object[0]), I18n.tr((String)"Subject", (Object[])new Object[0]), "Distance (m)", "Score", "Tags"};

    SimpleMatchesTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.matches == null) {
            return 0;
        }
        return this.matches.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.matches == null || row < 0 || row >= this.matches.size()) {
            return null;
        }
        SimpleMatch c = this.matches.get(row);
        if (col == 0) {
            return c.getReferenceObject();
        }
        if (col == 1) {
            return c.getSubjectObject();
        }
        if (col == 2) {
            return c.getDistance();
        }
        if (col == 3) {
            return c.getScore();
        }
        if (col == 4) {
            if (c.getMergingTagCollection(this.settings).getKeysWithMultipleValues().isEmpty()) {
                TagCollection tags = TagCollection.unionOfAllPrimitives(Arrays.asList(c.getReferenceObject(), c.getSubjectObject()));
                if (tags.getKeysWithMultipleValues().isEmpty()) {
                    return "No conflicts!";
                }
                return "Difference";
            }
            return "Conflicts!";
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object value = this.getValueAt(0, c);
        if (value != null) {
            return value.getClass();
        }
        return Object.class;
    }

    public SimpleMatchList getMatches() {
        return this.matches;
    }

    public void setMatches(SimpleMatchList matches, SimpleMatchSettings settings) {
        this.settings = settings;
        if (matches != this.matches) {
            if (this.matches != null) {
                this.matches.removeConflationListChangedListener(this);
            }
            this.matches = matches;
            if (matches != null) {
                matches.addConflationListChangedListener(this);
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public void simpleMatchListChanged(SimpleMatchList list) {
        this.fireTableDataChanged();
    }

    @Override
    public void simpleMatchListIntervalAdded(SimpleMatchList list, int index0, int index1) {
        this.fireTableRowsInserted(index0, index1);
    }

    @Override
    public void simpleMatchListIntervalRemoved(SimpleMatchList list, int index0, int index1) {
        this.fireTableRowsDeleted(index0, index1);
    }
}

