/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchListListener;

public class SimpleMatchList
implements Iterable<SimpleMatch> {
    private final CopyOnWriteArrayList<SimpleMatchListListener> listeners = new CopyOnWriteArrayList();
    private final ArrayList<SimpleMatch> matches = new ArrayList();
    private final HashMap<OsmPrimitive, SimpleMatch> byReference = new HashMap();
    private final HashMap<OsmPrimitive, SimpleMatch> bySubject = new HashMap();
    private int updateCount = 0;
    private boolean updateHasChanged = false;

    public boolean hasMatch(SimpleMatch c) {
        return this.hasMatchForReference(c.getReferenceObject());
    }

    public boolean hasMatch(OsmPrimitive referenceObject, OsmPrimitive subjectObject) {
        return this.hasMatchForReference(referenceObject) || this.hasMatchForSubject(subjectObject);
    }

    public boolean hasMatchForReference(OsmPrimitive referenceObject) {
        return this.getMatchByReference(referenceObject) != null;
    }

    public boolean hasMatchForSubject(OsmPrimitive subjectObject) {
        return this.getMatchBySubject(subjectObject) != null;
    }

    public SimpleMatch getMatchByReference(OsmPrimitive referenceObject) {
        return this.byReference.get(referenceObject);
    }

    public SimpleMatch getMatchBySubject(OsmPrimitive subjectObject) {
        return this.bySubject.get(subjectObject);
    }

    @Override
    public Iterator<SimpleMatch> iterator() {
        return this.matches.iterator();
    }

    public boolean add(SimpleMatch element) {
        int index = Collections.binarySearch(this.matches, element);
        if (index < 0) {
            index = -index - 1;
            this.matches.add(index, element);
            this.byReference.put(element.getReferenceObject(), element);
            this.bySubject.put(element.getSubjectObject(), element);
            this.fireIntervalAdded(index, index);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<SimpleMatch> toAdd) {
        if (this.matches.size() == 0 && toAdd.size() > 0) {
            this.matches.addAll(toAdd);
            Collections.sort(this.matches);
            for (SimpleMatch sm : toAdd) {
                this.byReference.put(sm.getReferenceObject(), sm);
                this.bySubject.put(sm.getSubjectObject(), sm);
            }
            this.fireListChanged();
            return true;
        }
        boolean changed = false;
        for (SimpleMatch sm : toAdd) {
            changed = this.add(sm) || changed;
        }
        return changed;
    }

    public int size() {
        return this.matches.size();
    }

    public SimpleMatch get(int index) {
        return this.matches.get(index);
    }

    public int indexOf(SimpleMatch match) {
        int index = Collections.binarySearch(this.matches, match);
        if (index < -1) {
            index = -1;
        }
        return index;
    }

    public void clear() {
        if (this.matches.size() > 0) {
            this.matches.clear();
            this.byReference.clear();
            this.bySubject.clear();
            this.fireListChanged();
        }
    }

    public boolean remove(SimpleMatch c) {
        return this.removeAll(Collections.singleton(c));
    }

    public boolean removeAll(Collection<SimpleMatch> matchesToRemove) {
        boolean isChanged = false;
        HashSet<Integer> removedIdx = new HashSet<Integer>();
        int maxSize = this.matches.size();
        for (SimpleMatch sm : matchesToRemove) {
            int index = Collections.binarySearch(this.matches, sm);
            if (index < 0) continue;
            this.byReference.remove(sm.getReferenceObject());
            this.bySubject.remove(sm.getSubjectObject());
            removedIdx.add(index);
            isChanged = true;
        }
        this.matches.removeAll(matchesToRemove);
        for (int i = 0; i < maxSize; ++i) {
            if (!removedIdx.contains(i)) continue;
            int startRange = i++;
            while (i < maxSize && removedIdx.contains(i)) {
                ++i;
            }
            this.fireIntervalRemoved(startRange, i - 1);
        }
        return isChanged;
    }

    public void addConflationListChangedListener(SimpleMatchListListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeConflationListChangedListener(SimpleMatchListListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllConflationListChangedListener() {
        this.listeners.clear();
    }

    public void fireListChanged() {
        if (!this.shouldFireEvent()) {
            return;
        }
        for (SimpleMatchListListener l : this.listeners) {
            l.simpleMatchListChanged(this);
        }
    }

    public void fireIntervalAdded(int index0, int index1) {
        if (!this.shouldFireEvent()) {
            return;
        }
        for (SimpleMatchListListener l : this.listeners) {
            l.simpleMatchListIntervalAdded(this, index0, index1);
        }
    }

    public void fireIntervalRemoved(int index0, int index1) {
        if (!this.shouldFireEvent()) {
            return;
        }
        for (SimpleMatchListListener l : this.listeners) {
            l.simpleMatchListIntervalRemoved(this, index0, index1);
        }
    }

    protected boolean shouldFireEvent() {
        if (this.updateCount > 0) {
            this.updateHasChanged = true;
            return false;
        }
        return true;
    }

    public void beginUpdate() {
        ++this.updateCount;
    }

    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            if (this.updateCount == 0 && this.updateHasChanged) {
                this.updateHasChanged = false;
                this.fireListChanged();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }
}

