/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.util.Arrays;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class SimpleMatch
implements Comparable<SimpleMatch> {
    final OsmPrimitive referenceObject;
    final OsmPrimitive subjectObject;
    final double score;
    final double distance;

    public SimpleMatch(OsmPrimitive referenceObject, OsmPrimitive subjectObject, double score) {
        this(referenceObject, subjectObject, score, ConflationUtils.getCenter(referenceObject).distance(ConflationUtils.getCenter(subjectObject)));
    }

    public SimpleMatch(OsmPrimitive referenceObject, OsmPrimitive subjectObject, double score, double distance) {
        CheckParameterUtil.ensureParameterNotNull((Object)referenceObject, (String)"referenceObject");
        CheckParameterUtil.ensureParameterNotNull((Object)subjectObject, (String)"subjectObject");
        this.referenceObject = referenceObject;
        this.subjectObject = subjectObject;
        this.score = score;
        this.distance = distance;
    }

    public OsmPrimitive getReferenceObject() {
        return this.referenceObject;
    }

    public OsmPrimitive getSubjectObject() {
        return this.subjectObject;
    }

    public Object getScore() {
        return this.score;
    }

    public Object getDistance() {
        return this.distance;
    }

    public TagCollection getMergingTagCollection(SimpleMatchSettings settings) {
        if (this.subjectObject.getId() > 0L && this.referenceObject.getId() > 0L && settings.isReplacingGeometry && this.referenceObject.getDataSet() == this.subjectObject.getDataSet()) {
            return TagCollection.unionOfAllPrimitives(Arrays.asList(this.subjectObject, this.referenceObject));
        }
        TagCollection tagCollection = TagCollection.from((Tagged)this.subjectObject);
        for (Tag refTag : this.referenceObject.getKeys().getTags()) {
            if (refTag.getValue().equals(this.subjectObject.get(refTag.getKey()))) continue;
            if (settings.overwriteTags.contains(refTag.getKey())) {
                tagCollection.removeByKey(refTag.getKey());
                tagCollection.add(refTag);
                continue;
            }
            if (!settings.mergeTags.contains(refTag.getKey()) && this.referenceObject.getId() <= 0L) continue;
            tagCollection.add(refTag);
        }
        return tagCollection;
    }

    @Override
    public int compareTo(SimpleMatch o) {
        int comp = Double.compare(this.score, o.score);
        if (comp == 0 && (comp = -Double.compare(this.distance, o.distance)) == 0 && (comp = this.referenceObject.compareTo((Object)o.referenceObject)) == 0) {
            comp = this.subjectObject.compareTo((Object)o.subjectObject);
        }
        return comp;
    }

    public int hashCode() {
        return this.referenceObject.hashCode() ^ this.subjectObject.hashCode();
    }
}

