/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import com.vividsolutions.jump.feature.AbstractBasicFeature;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.plugins.jts.JTSConverter;

public class OsmFeature
extends AbstractBasicFeature {
    private Object[] attributes;
    private final OsmPrimitive primitive;

    public OsmFeature(OsmPrimitive prim, JTSConverter jtsConverter) {
        super(new FeatureSchema());
        this.primitive = Objects.requireNonNull(prim);
        TagMap keys = prim.getKeys();
        this.attributes = new Object[keys.size() + 1];
        this.getSchema().addAttribute("__GEOMETRY__", AttributeType.GEOMETRY);
        keys.forEach((key, value) -> {
            this.getSchema().addAttribute((String)key, AttributeType.STRING);
            this.setAttribute((String)key, value);
        });
        JTSConverter converter = jtsConverter != null ? jtsConverter : new JTSConverter(true);
        this.setGeometry(converter.convert(prim));
    }

    @Override
    public void setAttributes(Object[] attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setAttribute(int attributeIndex, Object newAttribute) {
        this.attributes[attributeIndex] = newAttribute;
    }

    @Override
    public Object getAttribute(int i) {
        return this.attributes[i];
    }

    @Override
    public Object[] getAttributes() {
        return this.attributes;
    }

    public OsmPrimitive getPrimitive() {
        return this.primitive;
    }

    @Override
    public int getID() {
        return (int)this.primitive.getUniqueId();
    }

    @Override
    public int compareTo(Feature abstractBasicFeature) {
        int superCompare = super.compareTo(abstractBasicFeature);
        if (superCompare == 0 && abstractBasicFeature instanceof OsmFeature) {
            OsmFeature other = (OsmFeature)abstractBasicFeature;
            return this.primitive.compareTo((Object)other.primitive);
        }
        return superCompare;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass()) && Objects.equals(((OsmFeature)other).primitive, this.primitive);
    }

    public int hashCode() {
        return this.primitive.hashCode();
    }
}

