/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.conflation.OsmFeature;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.plugins.jts.JTSConverter;
import org.openstreetmap.josm.tools.I18n;

public final class MatchesComputation {
    private MatchesComputation() {
    }

    public static Collection<SimpleMatch> generateMatches(SimpleMatchSettings settings, ProgressMonitor monitor) {
        monitor.subTask("Generating matches");
        HashSet<OsmPrimitive> allPrimitives = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> refPrimitives = new HashSet<OsmPrimitive>(settings.referenceSelection);
        HashSet<OsmPrimitive> subPrimitives = new HashSet<OsmPrimitive>(settings.subjectSelection);
        allPrimitives.addAll(refPrimitives);
        allPrimitives.addAll(subPrimitives);
        FeatureCollection allFeatures = MatchesComputation.createFeatureCollection(allPrimitives);
        FeatureCollection refColl = new FeatureDataset(allFeatures.getFeatureSchema());
        FeatureCollection subColl = new FeatureDataset(allFeatures.getFeatureSchema());
        for (Feature f : allFeatures.getFeatures()) {
            OsmFeature osmFeature = (OsmFeature)f;
            if (refPrimitives.contains(osmFeature.getPrimitive())) {
                refColl.add(osmFeature);
            }
            if (!subPrimitives.contains(osmFeature.getPrimitive())) continue;
            subColl.add(osmFeature);
        }
        refColl = new IndexedFeatureCollection(refColl);
        subColl = new IndexedFeatureCollection(subColl);
        FCMatchFinder finder = settings.matchFinder;
        Map<Feature, Matches> map = finder.match(refColl, subColl, new TaskMonitorJosmAdapter(monitor));
        monitor.subTask("Finishing");
        ArrayList<SimpleMatch> list = new ArrayList<SimpleMatch>();
        for (Map.Entry<Feature, Matches> entry : map.entrySet()) {
            OsmFeature target = (OsmFeature)entry.getKey();
            OsmFeature subject = (OsmFeature)entry.getValue().getTopMatch();
            if (target == null || subject == null) continue;
            list.add(new SimpleMatch(target.getPrimitive(), subject.getPrimitive(), entry.getValue().getTopScore()));
        }
        return list;
    }

    private static FeatureSchema createSchema(Collection<OsmPrimitive> prims) {
        HashSet keys = new HashSet();
        for (OsmPrimitive prim : prims) {
            keys.addAll(prim.getKeys().keySet());
        }
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("__GEOMETRY__", AttributeType.GEOMETRY);
        for (String key : keys) {
            schema.addAttribute(key, AttributeType.STRING);
        }
        return schema;
    }

    private static FeatureCollection createFeatureCollection(Collection<OsmPrimitive> prims) {
        FeatureDataset dataset = new FeatureDataset(MatchesComputation.createSchema(prims));
        JTSConverter converter = new JTSConverter(true);
        for (OsmPrimitive prim : prims) {
            if (prim instanceof Relation) continue;
            dataset.add(new OsmFeature(prim, converter));
        }
        return dataset;
    }

    private static class TaskMonitorJosmAdapter
    implements TaskMonitor {
        private final ProgressMonitor josmMonitor;
        private final HashMap<String, String> translations = new HashMap();

        TaskMonitorJosmAdapter(ProgressMonitor josmMonitor) {
            this.translations.put("Finding matches", I18n.tr((String)"Finding matches", (Object[])new Object[0]));
            this.translations.put("Sorting scores", I18n.tr((String)"Sorting scores", (Object[])new Object[0]));
            this.translations.put("Discarding inferior matches", I18n.tr((String)"Discarding inferior matches", (Object[])new Object[0]));
            this.josmMonitor = josmMonitor;
        }

        @Override
        public void report(String description) {
            this.josmMonitor.subTask(this.translations.getOrDefault(description, description));
        }

        @Override
        public void report(int itemsDone, int totalItems, String itemDescription) {
            this.josmMonitor.setTicksCount(totalItems);
            this.josmMonitor.setTicks(itemsDone);
        }

        @Override
        public void report(Exception exception) {
            throw new UnsupportedOperationException("Not supported yet.", exception);
        }

        @Override
        public void allowCancellationRequests() {
        }

        @Override
        public boolean isCancelRequested() {
            return this.josmMonitor.isCanceled();
        }
    }
}

