/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.PrimitiveRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.conflation.ConflationLayer;
import org.openstreetmap.josm.plugins.conflation.ConflationPlugin;
import org.openstreetmap.josm.plugins.conflation.MatchesComputation;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchList;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchListListener;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchesTableModel;
import org.openstreetmap.josm.plugins.conflation.UnmatchedObjectListModel;
import org.openstreetmap.josm.plugins.conflation.command.ConflateMatchCommand;
import org.openstreetmap.josm.plugins.conflation.command.ConflateUnmatchedObjectCommand;
import org.openstreetmap.josm.plugins.conflation.command.MoveMatchToUnmatchedCommand;
import org.openstreetmap.josm.plugins.conflation.command.RemoveMatchCommand;
import org.openstreetmap.josm.plugins.conflation.command.RemoveUnmatchedObjectCommand;
import org.openstreetmap.josm.plugins.conflation.command.StopOnErrorSequenceCommand;
import org.openstreetmap.josm.plugins.conflation.config.SettingsDialog;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ConflationToggleDialog
extends ToggleDialog
implements DataSelectionListener,
DataSetListener,
SimpleMatchListListener,
LayerManager.LayerChangeListener {
    public static final String TITLE_PREFIX = I18n.tr((String)"Conflation", (Object[])new Object[0]);
    final JTabbedPane tabbedPane;
    final JTable matchTable;
    final JList<OsmPrimitive> referenceOnlyList;
    final UnmatchedObjectListModel referenceOnlyListModel;
    final JList<OsmPrimitive> subjectOnlyList;
    final UnmatchedObjectListModel subjectOnlyListModel;
    ConflationLayer conflationLayer;
    final SimpleMatchesTableModel matchTableModel;
    SimpleMatchList matches = new SimpleMatchList();
    SimpleMatchSettings settings;
    final SettingsDialog settingsDialog;
    final ConflateAction conflateAction;
    final SideButton conflateButton;
    final RemoveAction removeAction;
    final SideButton removeButton;
    final ZoomToListSelectionAction zoomToListSelectionAction;
    final SelectionPopup selectionPopup;
    private final HashSet<OsmPrimitive> primitivesRemovedReferenceOnly = new HashSet();
    private final HashSet<OsmPrimitive> primitivesRemovedSubjectOnly = new HashSet();
    private final HashMap<OsmPrimitive, SimpleMatch> primitivesRemovedMatchByReference = new HashMap();
    private final HashMap<OsmPrimitive, SimpleMatch> primitivesRemovedMatchBySubject = new HashMap();

    public ConflationToggleDialog(ConflationPlugin conflationPlugin, final IPreferences pref) {
        super(TITLE_PREFIX, "conflation.png", I18n.tr((String)"Activates the conflation plugin", (Object[])new Object[0]), null, 150);
        if (!GraphicsEnvironment.isHeadless()) {
            this.settingsDialog = new SettingsDialog(pref){

                protected void buttonAction(int buttonIndex, ActionEvent evt) {
                    if (buttonIndex == 0) {
                        if (this.checkValidityOrNotifyProblems()) {
                            super.buttonAction(buttonIndex, evt);
                            ConflationToggleDialog.this.clear(true, true, false);
                            ConflationToggleDialog.this.settings = this.getSettings();
                            ConflationToggleDialog.this.settingsDialog.savePreferences(pref);
                            ConflationToggleDialog.this.performMatching();
                        }
                    } else {
                        super.buttonAction(buttonIndex, evt);
                    }
                }
            };
            this.settingsDialog.setModalityType(Dialog.ModalityType.MODELESS);
        } else {
            this.settingsDialog = null;
        }
        this.matchTableModel = new SimpleMatchesTableModel();
        this.matchTable = new JTable(this.matchTableModel);
        this.matchTable.getSelectionModel().addListSelectionListener(new MatchListSelectionHandler());
        this.matchTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new PrimitiveRenderer());
        this.matchTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new PrimitiveRenderer());
        this.matchTable.getColumnModel().getColumn(4).setCellRenderer(new ColorTableCellRenderer("Tags"));
        this.matchTable.setRowSelectionAllowed(true);
        this.matchTable.setSelectionMode(2);
        this.matchTable.setAutoCreateRowSorter(true);
        this.referenceOnlyListModel = new UnmatchedObjectListModel();
        this.referenceOnlyList = new JList<OsmPrimitive>(this.referenceOnlyListModel);
        this.referenceOnlyList.setSelectionMode(2);
        this.referenceOnlyList.setCellRenderer((ListCellRenderer<OsmPrimitive>)new PrimitiveRenderer());
        this.referenceOnlyList.setTransferHandler(null);
        this.subjectOnlyListModel = new UnmatchedObjectListModel();
        this.subjectOnlyList = new JList<OsmPrimitive>(this.subjectOnlyListModel);
        this.subjectOnlyList.setSelectionMode(2);
        this.subjectOnlyList.setCellRenderer((ListCellRenderer<OsmPrimitive>)new PrimitiveRenderer());
        this.subjectOnlyList.setTransferHandler(null);
        this.zoomToListSelectionAction = new ZoomToListSelectionAction();
        this.selectionPopup = new SelectionPopup();
        SelectionPopupMenuLauncher launcher = new SelectionPopupMenuLauncher();
        this.matchTable.addMouseListener((MouseListener)((Object)launcher));
        this.subjectOnlyList.addMouseListener((MouseListener)((Object)launcher));
        this.referenceOnlyList.addMouseListener((MouseListener)((Object)launcher));
        InputMapUtils.addEnterAction((JComponent)this.matchTable, (Action)((Object)this.zoomToListSelectionAction));
        InputMapUtils.addEnterAction(this.subjectOnlyList, (Action)((Object)this.zoomToListSelectionAction));
        InputMapUtils.addEnterAction(this.referenceOnlyList, (Action)((Object)this.zoomToListSelectionAction));
        DoubleClickHandler dblClickHandler = new DoubleClickHandler();
        this.matchTable.addMouseListener(dblClickHandler);
        this.referenceOnlyList.addMouseListener(dblClickHandler);
        this.subjectOnlyList.addMouseListener(dblClickHandler);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(I18n.tr((String)"Matches", (Object[])new Object[0]), new JScrollPane(this.matchTable));
        this.tabbedPane.addTab(I18n.tr((String)"Reference only", (Object[])new Object[0]), new JScrollPane(this.referenceOnlyList));
        this.tabbedPane.addTab(I18n.tr((String)"Subject only", (Object[])new Object[0]), new JScrollPane(this.subjectOnlyList));
        this.conflateAction = new ConflateAction();
        this.conflateButton = new SideButton((Action)((Object)this.conflateAction));
        this.removeAction = new RemoveAction();
        this.removeButton = new SideButton((Action)((Object)this.removeAction));
        this.matchTable.getSelectionModel().addListSelectionListener(this.conflateAction);
        this.matchTable.getSelectionModel().addListSelectionListener(this.removeAction);
        this.tabbedPane.addChangeListener(this.conflateAction);
        this.tabbedPane.addChangeListener(this.removeAction);
        this.referenceOnlyList.addListSelectionListener(this.conflateAction);
        this.referenceOnlyList.addListSelectionListener(this.removeAction);
        this.subjectOnlyList.addListSelectionListener(this.conflateAction);
        this.subjectOnlyList.addListSelectionListener(this.removeAction);
        UnmatchedListDataListener unmatchedListener = new UnmatchedListDataListener();
        this.subjectOnlyListModel.addListDataListener(unmatchedListener);
        this.referenceOnlyListModel.addListDataListener(unmatchedListener);
        this.createLayout(this.tabbedPane, false, Arrays.asList(new SideButton((Action)((Object)new ConfigureAction())), this.conflateButton, this.removeButton));
    }

    @Override
    public void simpleMatchListChanged(SimpleMatchList list) {
        this.updateTabTitles();
    }

    @Override
    public void simpleMatchListIntervalAdded(SimpleMatchList list, int index0, int index1) {
        this.updateTabTitles();
    }

    @Override
    public void simpleMatchListIntervalRemoved(SimpleMatchList list, int index0, int index1) {
        this.updateTabTitles();
    }

    private void updateTabTitles() {
        this.tabbedPane.setTitleAt(this.tabbedPane.indexOfComponent(this.matchTable.getParent().getParent()), I18n.tr((String)I18n.marktr((String)"Matches ({0})"), (Object[])new Object[]{this.matches.size()}));
        this.tabbedPane.setTitleAt(this.tabbedPane.indexOfComponent(this.referenceOnlyList.getParent().getParent()), I18n.tr((String)I18n.marktr((String)"Reference only ({0})"), (Object[])new Object[]{this.referenceOnlyListModel.getSize()}));
        this.tabbedPane.setTitleAt(this.tabbedPane.indexOfComponent(this.subjectOnlyList.getParent().getParent()), I18n.tr((String)I18n.marktr((String)"Subject only ({0})"), (Object[])new Object[]{this.subjectOnlyListModel.getSize()}));
    }

    private Component getSelectedTabComponent() {
        return ((JScrollPane)this.tabbedPane.getSelectedComponent()).getViewport().getView();
    }

    private Stream<SimpleMatch> getSelectedMatchesStream() {
        return IntStream.of(this.matchTable.getSelectedRows()).map(this.matchTable::convertRowIndexToModel).mapToObj(this.matches::get);
    }

    private Collection<SimpleMatch> getSelectedMatches() {
        return this.getSelectedMatchesStream().collect(Collectors.toList());
    }

    private List<OsmPrimitive> getSelectedReferencePrimitives() {
        ArrayList<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
        if (this.tabbedPane == null || this.getSelectedTabComponent() == null) {
            return selection;
        }
        if (this.getSelectedTabComponent().equals(this.matchTable)) {
            selection.addAll(this.getSelectedMatchesStream().map(SimpleMatch::getReferenceObject).collect(Collectors.toList()));
        } else if (this.getSelectedTabComponent().equals(this.referenceOnlyList)) {
            selection.addAll(this.referenceOnlyList.getSelectedValuesList());
        }
        return selection;
    }

    private List<OsmPrimitive> getSelectedSubjectPrimitives() {
        ArrayList<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
        if (this.tabbedPane == null || this.getSelectedTabComponent() == null) {
            return selection;
        }
        if (this.getSelectedTabComponent().equals(this.matchTable)) {
            selection.addAll(this.getSelectedMatchesStream().map(SimpleMatch::getSubjectObject).collect(Collectors.toList()));
        } else if (this.getSelectedTabComponent().equals(this.subjectOnlyList)) {
            selection.addAll(this.subjectOnlyList.getSelectedValuesList());
        }
        return selection;
    }

    private boolean isSelectionEmpty() {
        if (this.tabbedPane == null || this.getSelectedTabComponent() == null) {
            return true;
        }
        if (this.getSelectedTabComponent().equals(this.matchTable)) {
            return this.matchTable.getSelectedRow() < 0;
        }
        if (this.getSelectedTabComponent().equals(this.referenceOnlyList)) {
            return this.referenceOnlyList.getSelectedIndex() < 0;
        }
        if (this.getSelectedTabComponent().equals(this.subjectOnlyList)) {
            return this.subjectOnlyList.getSelectedIndex() < 0;
        }
        throw new AssertionError();
    }

    private Collection<OsmPrimitive> getAllSelectedPrimitives() {
        HashSet<OsmPrimitive> allSelected = new HashSet<OsmPrimitive>();
        allSelected.addAll(this.getSelectedReferencePrimitives());
        allSelected.addAll(this.getSelectedSubjectPrimitives());
        return allSelected;
    }

    private void selectAllListSelectedPrimitives() {
        List<OsmPrimitive> refSelected = this.getSelectedReferencePrimitives();
        List<OsmPrimitive> subSelected = this.getSelectedSubjectPrimitives();
        this.settings.referenceDataSet.clearSelection();
        this.settings.subjectDataSet.clearSelection();
        SelectionEventManager.getInstance().removeSelectionListener((DataSelectionListener)this);
        try {
            this.settings.referenceDataSet.addSelected(refSelected);
            this.settings.subjectDataSet.addSelected(subSelected);
        }
        finally {
            SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        }
    }

    public void showNotify() {
        super.showNotify();
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    public void hideNotify() {
        super.hideNotify();
        SelectionEventManager.getInstance().removeSelectionListener((DataSelectionListener)this);
        MainApplication.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        this.clear(true, true, true);
        if (this.settingsDialog != null) {
            this.settingsDialog.setVisible(false);
            this.settingsDialog.clear(true, true);
        }
        this.settings = null;
    }

    private void clear(boolean shouldClearReference, boolean shouldClearSubject, boolean shouldRemoveConflationLayer) {
        if (shouldRemoveConflationLayer && this.conflationLayer != null) {
            if (MainApplication.getLayerManager().containsLayer((Layer)this.conflationLayer)) {
                MainApplication.getLayerManager().removeLayer((Layer)this.conflationLayer);
            }
            this.conflationLayer = null;
        }
        if (this.settings != null) {
            DataSet dataSet;
            if (shouldClearReference) {
                dataSet = this.settings.referenceDataSet;
                if (dataSet != null) {
                    dataSet.removeDataSetListener((DataSetListener)this);
                    this.settings.referenceDataSet = null;
                }
                this.settings.referenceLayer = null;
                this.settings.referenceSelection = null;
            }
            if (shouldClearSubject) {
                dataSet = this.settings.subjectDataSet;
                if (dataSet != null) {
                    dataSet.removeDataSetListener((DataSetListener)this);
                    this.settings.subjectDataSet = null;
                }
                this.settings.subjectLayer = null;
                this.settings.subjectSelection = null;
            }
        }
        this.clearListsContentAndListeners();
    }

    private void clearListsContentAndListeners() {
        this.primitivesRemovedReferenceOnly.clear();
        this.primitivesRemovedSubjectOnly.clear();
        this.primitivesRemovedMatchByReference.clear();
        this.primitivesRemovedMatchBySubject.clear();
        this.matches.clear();
        this.matches.removeAllConflationListChangedListener();
        this.referenceOnlyListModel.clear();
        this.subjectOnlyListModel.clear();
        this.updateTabTitles();
    }

    private void setListsContentAddListnersAndLayer(SimpleMatchList matchList, Collection<OsmPrimitive> referenceOnlyList, Collection<OsmPrimitive> subjectOnlyList) {
        this.clearListsContentAndListeners();
        this.matches = matchList;
        this.matchTableModel.setMatches(this.matches, this.settings);
        this.matches.addConflationListChangedListener(this);
        try {
            if (this.conflationLayer == null) {
                this.conflationLayer = new ConflationLayer(this.matches, i -> this.matchTable.isRowSelected(this.matchTable.convertRowIndexToView(i)));
            }
            if (!MainApplication.getLayerManager().containsLayer((Layer)this.conflationLayer)) {
                MainApplication.getLayerManager().addLayer((Layer)this.conflationLayer);
            }
        }
        catch (Exception ex) {
            Logging.error((Throwable)ex);
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), ex.toString(), "Error adding conflation layer", 0);
        }
        if (this.conflationLayer != null) {
            this.conflationLayer.setMatches(this.matches);
        }
        this.referenceOnlyListModel.addAll(referenceOnlyList);
        this.subjectOnlyListModel.addAll(subjectOnlyList);
        this.updateTabTitles();
        this.settings.subjectDataSet.addDataSetListener((DataSetListener)this);
        this.settings.referenceDataSet.addDataSetListener((DataSetListener)this);
    }

    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        if (!this.isShowing() || this.isDocked && this.isCollapsed) {
            return;
        }
        Set newSelection = event.getSelection();
        if (newSelection.size() > 0) {
            ListSelectionModel refOnlySelModel = this.referenceOnlyList.getSelectionModel();
            ListSelectionModel subOnlySelModel = this.subjectOnlyList.getSelectionModel();
            ListSelectionModel matchSelModel = this.matchTable.getSelectionModel();
            if (newSelection.size() <= 50 && (this.matches.size() >= 400 || this.referenceOnlyListModel.getSize() >= 400 || this.subjectOnlyListModel.getSize() >= 400)) {
                refOnlySelModel.setValueIsAdjusting(true);
                refOnlySelModel.clearSelection();
                subOnlySelModel.setValueIsAdjusting(true);
                subOnlySelModel.clearSelection();
                matchSelModel.setValueIsAdjusting(true);
                matchSelModel.clearSelection();
                newSelection.forEach(this::addPrimitiveToSelection);
                refOnlySelModel.setValueIsAdjusting(false);
                subOnlySelModel.setValueIsAdjusting(false);
                matchSelModel.setValueIsAdjusting(false);
            } else {
                HashSet selectionSet = new HashSet(newSelection);
                Predicate<SimpleMatch> isMatchSelected = m -> selectionSet.contains(m.getReferenceObject()) || selectionSet.contains(m.getSubjectObject());
                ConflationToggleDialog.select(matchSelModel, this.matches.size(), i -> isMatchSelected.test(this.matches.get(this.matchTable.convertRowIndexToModel(i))));
                ConflationToggleDialog.select(refOnlySelModel, this.referenceOnlyListModel.getSize(), i -> selectionSet.contains(this.referenceOnlyListModel.getElementAt(i)));
                ConflationToggleDialog.select(subOnlySelModel, this.subjectOnlyListModel.getSize(), i -> selectionSet.contains(this.subjectOnlyListModel.getElementAt(i)));
            }
            if (matchSelModel.getMinSelectionIndex() >= 0) {
                this.tabbedPane.setSelectedIndex(0);
                this.matchTable.scrollRectToVisible(new Rectangle(this.matchTable.getCellRect(matchSelModel.getMinSelectionIndex(), 0, true)));
            } else if (refOnlySelModel.getMinSelectionIndex() >= 0) {
                this.tabbedPane.setSelectedIndex(1);
            } else if (subOnlySelModel.getMinSelectionIndex() >= 0) {
                this.tabbedPane.setSelectedIndex(2);
            }
            ConflationToggleDialog.scrollListToSelected(this.referenceOnlyList);
            ConflationToggleDialog.scrollListToSelected(this.subjectOnlyList);
        }
    }

    private static void select(ListSelectionModel selectionModel, int size, IntPredicate predicate) {
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        int i = 0;
        while (i < size) {
            int j;
            while (i < size && !predicate.test(i)) {
                ++i;
            }
            if (i == size) break;
            for (j = i + 1; j < size && predicate.test(j); ++j) {
            }
            selectionModel.addSelectionInterval(i, j - 1);
            i = j + 1;
        }
        selectionModel.setValueIsAdjusting(false);
    }

    private static void scrollListToSelected(JList<?> jlist) {
        ListSelectionModel selectionModel = jlist.getSelectionModel();
        int index = selectionModel.getMinSelectionIndex();
        if (index >= 0) {
            jlist.ensureIndexIsVisible(index);
        }
    }

    private void addPrimitiveToSelection(OsmPrimitive object) {
        int index;
        SimpleMatch c = this.matches.getMatchByReference(object);
        if (c == null) {
            c = this.matches.getMatchBySubject(object);
        }
        if (c != null && (index = this.matches.indexOf(c)) >= 0) {
            index = this.matchTable.convertRowIndexToView(index);
            this.matchTable.getSelectionModel().addSelectionInterval(index, index);
        }
        if ((index = this.referenceOnlyListModel.indexOf(object)) >= 0) {
            this.referenceOnlyList.getSelectionModel().addSelectionInterval(index, index);
        }
        if ((index = this.subjectOnlyListModel.indexOf(object)) >= 0) {
            this.subjectOnlyList.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    private SimpleMatch getNextMatchToSelect() {
        int index;
        for (index = this.matchTable.getSelectedRow() + 1; index < this.matches.size() && this.matchTable.isRowSelected(index); ++index) {
        }
        return index >= 0 && index < this.matches.size() ? this.matches.get(this.matchTable.convertRowIndexToModel(index)) : null;
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
        block4: {
            DataSet dataSet;
            block5: {
                if (this.settings == null) break block4;
                dataSet = event.getDataset();
                if (dataSet != this.settings.referenceDataSet) break block5;
                for (OsmPrimitive p : event.getPrimitives()) {
                    SimpleMatch m = this.primitivesRemovedMatchByReference.remove(p);
                    if (m != null) {
                        this.matches.add(m);
                    }
                    if (!this.primitivesRemovedReferenceOnly.remove(p)) continue;
                    this.referenceOnlyListModel.addElement(p);
                }
                break block4;
            }
            if (dataSet != this.settings.subjectDataSet) break block4;
            for (OsmPrimitive p : event.getPrimitives()) {
                SimpleMatch m = this.primitivesRemovedMatchBySubject.remove(p);
                if (m != null) {
                    this.matches.add(m);
                }
                if (!this.primitivesRemovedSubjectOnly.remove(p)) continue;
                this.subjectOnlyListModel.addElement(p);
            }
        }
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        block4: {
            DataSet dataSet;
            block5: {
                if (this.settings == null) break block4;
                dataSet = event.getDataset();
                if (dataSet != this.settings.referenceDataSet) break block5;
                for (OsmPrimitive p : event.getPrimitives()) {
                    SimpleMatch m = this.matches.getMatchByReference(p);
                    if (m != null) {
                        this.primitivesRemovedMatchByReference.put(p, m);
                        this.matches.remove(m);
                    }
                    if (!this.referenceOnlyListModel.removeElement(p)) continue;
                    this.primitivesRemovedReferenceOnly.add(p);
                }
                break block4;
            }
            if (dataSet != this.settings.subjectDataSet) break block4;
            for (OsmPrimitive p : event.getPrimitives()) {
                SimpleMatch m = this.matches.getMatchBySubject(p);
                if (m != null) {
                    this.primitivesRemovedMatchBySubject.put(p, m);
                    this.matches.remove(m);
                }
                if (!this.subjectOnlyListModel.removeElement(p)) continue;
                this.primitivesRemovedSubjectOnly.add(p);
            }
        }
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void dataChanged(DataChangedEvent event) {
        if (this.settings != null) {
            DataSet dataSet = event.getDataset();
            if (dataSet == this.settings.referenceDataSet) {
                this.primitivesRemovedMatchByReference.entrySet().removeIf(entry -> {
                    if (!((OsmPrimitive)entry.getKey()).isDeleted()) {
                        this.matches.add((SimpleMatch)entry.getValue());
                        return true;
                    }
                    return false;
                });
                this.primitivesRemovedReferenceOnly.removeIf(osmPrimitive -> {
                    if (!osmPrimitive.isDeleted()) {
                        this.referenceOnlyListModel.addElement((OsmPrimitive)osmPrimitive);
                        return true;
                    }
                    return false;
                });
            } else if (dataSet == this.settings.subjectDataSet) {
                this.primitivesRemovedMatchBySubject.entrySet().removeIf(entry -> {
                    if (!((OsmPrimitive)entry.getKey()).isDeleted()) {
                        this.matches.add((SimpleMatch)entry.getValue());
                        return true;
                    }
                    return false;
                });
                this.primitivesRemovedSubjectOnly.removeIf(osmPrimitive -> {
                    if (!osmPrimitive.isDeleted()) {
                        this.subjectOnlyListModel.addElement((OsmPrimitive)osmPrimitive);
                        return true;
                    }
                    return false;
                });
            }
        }
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        Layer removedLayer = e.getRemovedLayer();
        if (this.settings != null) {
            boolean shouldclearSubjectSettings;
            boolean shouldclearReferenceSettings = removedLayer == this.settings.referenceLayer;
            boolean bl = shouldclearSubjectSettings = removedLayer == this.settings.subjectLayer;
            if (shouldclearReferenceSettings || shouldclearSubjectSettings) {
                this.clear(shouldclearReferenceSettings, shouldclearSubjectSettings, true);
            }
        }
        this.settingsDialog.layerRemoving(e);
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    private void performMatching() {
        MainApplication.worker.submit((Runnable)new PleaseWaitRunnable(I18n.tr((String)"Generating matches", (Object[])new Object[0])){
            private SimpleMatchList computedMatches;
            private Collection<OsmPrimitive> referenceOnlyList;
            private Collection<OsmPrimitive> subjectOnlyList;
            boolean executionOk;
            {
                this.executionOk = false;
            }

            protected void realRun() throws SAXException, IOException, OsmTransferException {
                this.computedMatches = new SimpleMatchList();
                this.computedMatches.addAll(MatchesComputation.generateMatches(ConflationToggleDialog.this.settings, this.getProgressMonitor()));
                if (!this.getProgressMonitor().isCanceled()) {
                    this.referenceOnlyList = ConflationToggleDialog.this.settings.referenceSelection.stream().filter(r -> !this.computedMatches.hasMatchForReference((OsmPrimitive)r)).collect(Collectors.toList());
                    this.subjectOnlyList = ConflationToggleDialog.this.settings.subjectSelection.stream().filter(s -> !this.computedMatches.hasMatchForSubject((OsmPrimitive)s)).collect(Collectors.toList());
                }
                this.executionOk = true;
            }

            protected void finish() {
                if (!this.getProgressMonitor().isCanceled() && this.executionOk) {
                    ConflationToggleDialog.this.setListsContentAddListnersAndLayer(this.computedMatches, this.referenceOnlyList, this.subjectOnlyList);
                }
            }

            protected void cancel() {
            }
        });
    }

    class UnmatchedListDataListener
    implements ListDataListener {
        UnmatchedListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent lde) {
            ConflationToggleDialog.this.updateTabTitles();
        }

        @Override
        public void intervalRemoved(ListDataEvent lde) {
            ConflationToggleDialog.this.updateTabTitles();
        }

        @Override
        public void contentsChanged(ListDataEvent lde) {
            ConflationToggleDialog.this.updateTabTitles();
        }
    }

    class SelectionPopup
    extends JPopupMenu {
        public SelectListSelectionAction selectListSelectionAction;

        SelectionPopup() {
            ConflationToggleDialog.this.matchTable.getSelectionModel().addListSelectionListener(ConflationToggleDialog.this.zoomToListSelectionAction);
            ConflationToggleDialog.this.subjectOnlyList.addListSelectionListener(ConflationToggleDialog.this.zoomToListSelectionAction);
            ConflationToggleDialog.this.referenceOnlyList.addListSelectionListener(ConflationToggleDialog.this.zoomToListSelectionAction);
            this.add((Action)((Object)ConflationToggleDialog.this.zoomToListSelectionAction));
            this.selectListSelectionAction = new SelectListSelectionAction();
            ConflationToggleDialog.this.matchTable.getSelectionModel().addListSelectionListener(this.selectListSelectionAction);
            ConflationToggleDialog.this.subjectOnlyList.addListSelectionListener(this.selectListSelectionAction);
            ConflationToggleDialog.this.referenceOnlyList.addListSelectionListener(this.selectListSelectionAction);
            this.add((Action)((Object)this.selectListSelectionAction));
        }
    }

    class SelectionPopupMenuLauncher
    extends PopupMenuLauncher {
        SelectionPopupMenuLauncher() {
        }

        public void launch(MouseEvent evt) {
            Component c = ConflationToggleDialog.this.getSelectedTabComponent();
            int rowIndex = -1;
            if (c == ConflationToggleDialog.this.matchTable) {
                rowIndex = ConflationToggleDialog.this.matchTable.rowAtPoint(evt.getPoint());
                if (rowIndex >= 0) {
                    ConflationToggleDialog.this.matchTable.addRowSelectionInterval(rowIndex, rowIndex);
                }
            } else if ((c == ConflationToggleDialog.this.subjectOnlyList || c == ConflationToggleDialog.this.referenceOnlyList) && (rowIndex = ((JList)c).locationToIndex(evt.getPoint())) >= 0) {
                ((JList)c).addSelectionInterval(rowIndex, rowIndex);
            }
            if (rowIndex >= 0) {
                ConflationToggleDialog.this.selectionPopup.show(c, evt.getX(), evt.getY());
            }
        }
    }

    class SelectListSelectionAction
    extends BatchAction
    implements ListSelectionListener {
        SelectListSelectionAction() {
            super(I18n.tr((String)"Select selected primitive(s)", (Object[])new Object[0]), "dialogs/select", I18n.tr((String)"Select the primitives currently selected in the list", (Object[])new Object[0]), null, false);
        }

        @Override
        public void actualActionPerformed(ActionEvent e) {
            if (ConflationToggleDialog.this.matchTable == null) {
                return;
            }
            ConflationToggleDialog.this.selectAllListSelectedPrimitives();
        }

        public void updateEnabledState() {
            this.setEnabled(!ConflationToggleDialog.this.isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (!lse.getValueIsAdjusting()) {
                this.updateEnabledState();
            }
        }
    }

    class ZoomToListSelectionAction
    extends BatchAction
    implements ListSelectionListener {
        ZoomToListSelectionAction() {
            super(I18n.tr((String)"Zoom to selected primitive(s)", (Object[])new Object[0]), "dialogs/autoscale/selection", I18n.tr((String)"Zoom to selected primitive(s)", (Object[])new Object[0]), null, false);
        }

        @Override
        public void actualActionPerformed(ActionEvent e) {
            if (ConflationToggleDialog.this.matchTable == null) {
                return;
            }
            Collection sel = ConflationToggleDialog.this.getAllSelectedPrimitives();
            if (sel.isEmpty()) {
                return;
            }
            AutoScaleAction.zoomTo((Collection)sel);
        }

        public void updateEnabledState() {
            this.setEnabled(!ConflationToggleDialog.this.isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (!lse.getValueIsAdjusting()) {
                this.updateEnabledState();
            }
        }
    }

    class ConflateAction
    extends BatchAction
    implements ChangeListener,
    ListSelectionListener {
        ConflateAction() {
            super(I18n.tr((String)"Conflate", (Object[])new Object[0]), "dialogs/conflation", I18n.tr((String)"Conflate selected objects", (Object[])new Object[0]), Shortcut.registerShortcut((String)"conflation:replace", (String)I18n.tr((String)"Conflation: {0}", (Object[])new Object[]{I18n.tr((String)"Replace", (Object[])new Object[0])}), (int)70, (int)5008), false);
        }

        @Override
        public void actualActionPerformed(ActionEvent e) {
            if (ConflationToggleDialog.this.getSelectedTabComponent().equals(ConflationToggleDialog.this.matchTable)) {
                this.conflateMatchActionPerformed();
            } else if (ConflationToggleDialog.this.getSelectedTabComponent().equals(ConflationToggleDialog.this.referenceOnlyList)) {
                this.conflateUnmatchedObjectActionPerformed();
            }
        }

        private void conflateUnmatchedObjectActionPerformed() {
            List<OsmPrimitive> unmatchedObjects = ConflationToggleDialog.this.referenceOnlyList.getSelectedValuesList();
            ConflateUnmatchedObjectCommand cmd = new ConflateUnmatchedObjectCommand(ConflationToggleDialog.this.settings.referenceLayer, ConflationToggleDialog.this.settings.subjectDataSet, unmatchedObjects, ConflationToggleDialog.this.referenceOnlyListModel);
            UndoRedoHandler.getInstance().add((Command)cmd);
        }

        private void conflateMatchActionPerformed() {
            List<Command> cmds = ConflationToggleDialog.this.getSelectedMatchesStream().map(match -> new ConflateMatchCommand((SimpleMatch)match, ConflationToggleDialog.this.matches, ConflationToggleDialog.this.settings)).collect(Collectors.toList());
            if (cmds.size() == 1) {
                UndoRedoHandler.getInstance().add((Command)cmds.get(0));
            } else if (cmds.size() > 1) {
                StopOnErrorSequenceCommand seqCmd = new StopOnErrorSequenceCommand(ConflationToggleDialog.this.settings.subjectDataSet, I18n.tr((String)I18n.marktr((String)"Conflate {0} objects"), (Object[])new Object[]{cmds.size()}), true, cmds);
                UndoRedoHandler.getInstance().add((Command)seqCmd);
            }
        }

        public void updateEnabledState() {
            Component selComponent = ConflationToggleDialog.this.getSelectedTabComponent();
            int selSize = 0;
            if (selComponent.equals(ConflationToggleDialog.this.matchTable)) {
                selSize = ConflationToggleDialog.this.matchTable.getSelectedRowCount();
            } else if (selComponent.equals(ConflationToggleDialog.this.referenceOnlyList)) {
                selSize = ConflationToggleDialog.this.referenceOnlyList.getSelectedValuesList().size();
            }
            if (ConflationToggleDialog.this.conflateButton != null) {
                ConflationToggleDialog.this.conflateButton.setText(selSize > 1 ? I18n.tr((String)I18n.marktr((String)"Conflate ({0})"), (Object[])new Object[]{selSize}) : I18n.tr((String)"Conflate", (Object[])new Object[0]));
            }
            this.setEnabled(selSize > 0);
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (!lse.getValueIsAdjusting()) {
                this.updateEnabledState();
            }
        }
    }

    class RemoveAction
    extends BatchAction
    implements ChangeListener,
    ListSelectionListener {
        RemoveAction() {
            super(I18n.tr((String)"Remove", (Object[])new Object[0]), "dialogs/delete", I18n.tr((String)"Remove selected matches", (Object[])new Object[0]), null, false);
        }

        @Override
        public void actualActionPerformed(ActionEvent e) {
            Component selComponent = ConflationToggleDialog.this.getSelectedTabComponent();
            if (selComponent.equals(ConflationToggleDialog.this.matchTable)) {
                if ((e.getModifiers() & 1) != 0) {
                    UndoRedoHandler.getInstance().add((Command)new MoveMatchToUnmatchedCommand(ConflationToggleDialog.this.matches, ConflationToggleDialog.this.getSelectedMatches(), ConflationToggleDialog.this.referenceOnlyListModel, ConflationToggleDialog.this.subjectOnlyListModel));
                } else {
                    UndoRedoHandler.getInstance().add((Command)new RemoveMatchCommand(ConflationToggleDialog.this.matches, ConflationToggleDialog.this.getSelectedMatches()));
                }
            } else if (selComponent.equals(ConflationToggleDialog.this.referenceOnlyList)) {
                UndoRedoHandler.getInstance().add((Command)new RemoveUnmatchedObjectCommand(ConflationToggleDialog.this.referenceOnlyListModel, ConflationToggleDialog.this.referenceOnlyList.getSelectedValuesList()));
            } else if (selComponent.equals(ConflationToggleDialog.this.subjectOnlyList)) {
                UndoRedoHandler.getInstance().add((Command)new RemoveUnmatchedObjectCommand(ConflationToggleDialog.this.subjectOnlyListModel, ConflationToggleDialog.this.subjectOnlyList.getSelectedValuesList()));
            }
        }

        public void updateEnabledState() {
            Component selComponent = ConflationToggleDialog.this.getSelectedTabComponent();
            int selSize = 0;
            if (selComponent.equals(ConflationToggleDialog.this.matchTable)) {
                selSize = ConflationToggleDialog.this.matchTable.getSelectedRowCount();
            } else if (selComponent.equals(ConflationToggleDialog.this.referenceOnlyList)) {
                selSize = ConflationToggleDialog.this.referenceOnlyList.getSelectedValuesList().size();
            } else if (selComponent.equals(ConflationToggleDialog.this.subjectOnlyList)) {
                selSize = ConflationToggleDialog.this.subjectOnlyList.getSelectedValuesList().size();
            }
            if (ConflationToggleDialog.this.removeButton != null) {
                ConflationToggleDialog.this.removeButton.setText(selSize > 1 ? I18n.tr((String)I18n.marktr((String)"Remove ({0})"), (Object[])new Object[]{selSize}) : I18n.tr((String)"Remove", (Object[])new Object[0]));
            }
            this.setEnabled(selSize > 0);
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (!lse.getValueIsAdjusting()) {
                this.updateEnabledState();
            }
        }
    }

    abstract class BatchAction
    extends JosmAction {
        private SimpleMatch nextMatchSelection;
        private HashSet<SimpleMatch> oldMatchesSelection;
        private HashSet<OsmPrimitive> oldReferenceOnlySelection;
        private HashSet<OsmPrimitive> oldSubjectOnlySelection;

        BatchAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
            super(name, iconName, tooltip, shortcut, registerInToolbar);
            this.oldMatchesSelection = new HashSet();
            this.oldReferenceOnlySelection = new HashSet();
            this.oldSubjectOnlySelection = new HashSet();
        }

        public final void actionPerformed(ActionEvent e) {
            this.saveSelection();
            this.beginUpdate();
            try {
                this.actualActionPerformed(e);
            }
            finally {
                this.endUpdate();
                this.restoreSelection();
            }
        }

        public abstract void actualActionPerformed(ActionEvent var1);

        private void beginUpdate() {
            SelectionEventManager.getInstance().removeSelectionListener((DataSelectionListener)ConflationToggleDialog.this);
            if (ConflationToggleDialog.this.settings.subjectDataSet != null) {
                ConflationToggleDialog.this.settings.subjectDataSet.beginUpdate();
            }
            ConflationToggleDialog.this.matches.beginUpdate();
            ConflationToggleDialog.this.referenceOnlyListModel.beginUpdate();
            ConflationToggleDialog.this.subjectOnlyListModel.beginUpdate();
        }

        private void endUpdate() {
            SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)ConflationToggleDialog.this);
            if (ConflationToggleDialog.this.settings.subjectDataSet != null) {
                ConflationToggleDialog.this.settings.subjectDataSet.endUpdate();
            }
            ConflationToggleDialog.this.matches.endUpdate();
            ConflationToggleDialog.this.referenceOnlyListModel.endUpdate();
            ConflationToggleDialog.this.subjectOnlyListModel.endUpdate();
        }

        private void saveSelection() {
            this.nextMatchSelection = ConflationToggleDialog.this.getNextMatchToSelect();
            this.oldMatchesSelection.addAll(ConflationToggleDialog.this.getSelectedMatches());
            this.oldReferenceOnlySelection.addAll(ConflationToggleDialog.this.referenceOnlyList.getSelectedValuesList());
            this.oldSubjectOnlySelection.addAll(ConflationToggleDialog.this.subjectOnlyList.getSelectedValuesList());
        }

        private void restoreSelection() {
            ConflationToggleDialog.select(ConflationToggleDialog.this.matchTable.getSelectionModel(), ConflationToggleDialog.this.matches.size(), i -> this.oldMatchesSelection.contains(ConflationToggleDialog.this.matches.get(ConflationToggleDialog.this.matchTable.convertRowIndexToModel(i))));
            ConflationToggleDialog.select(ConflationToggleDialog.this.referenceOnlyList.getSelectionModel(), ConflationToggleDialog.this.referenceOnlyListModel.getSize(), i -> this.oldReferenceOnlySelection.contains(ConflationToggleDialog.this.referenceOnlyListModel.getElementAt(i)));
            ConflationToggleDialog.select(ConflationToggleDialog.this.subjectOnlyList.getSelectionModel(), ConflationToggleDialog.this.subjectOnlyListModel.getSize(), i -> this.oldSubjectOnlySelection.contains(ConflationToggleDialog.this.subjectOnlyListModel.getElementAt(i)));
            if (ConflationToggleDialog.this.matchTable.getSelectedRow() < 0 && this.nextMatchSelection != null) {
                int index = ConflationToggleDialog.this.matchTable.convertRowIndexToView(ConflationToggleDialog.this.matches.indexOf(this.nextMatchSelection));
                ConflationToggleDialog.this.matchTable.setRowSelectionInterval(index, index);
            }
            this.nextMatchSelection = null;
            this.oldMatchesSelection.clear();
            this.oldReferenceOnlySelection.clear();
            this.oldSubjectOnlySelection.clear();
        }
    }

    static class ColorTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private final String columnName;

        ColorTableCellRenderer(String column) {
            this.columnName = column;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object columnValue = table.getValueAt(row, table.getColumnModel().getColumnIndex(this.columnName));
            if (value != null) {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
                if ("Conflicts!".equals(columnValue)) {
                    this.setBackground(Color.red);
                } else if ("Difference".equals(columnValue)) {
                    this.setBackground(Color.orange);
                } else {
                    this.setBackground(Color.green);
                }
            }
            return this;
        }
    }

    class MatchListSelectionHandler
    implements ListSelectionListener {
        MatchListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (ConflationToggleDialog.this.conflationLayer != null && !lse.getValueIsAdjusting()) {
                MainApplication.getMap().mapView.repaint();
            }
        }
    }

    public class ConfigureAction
    extends JosmAction {
        public ConfigureAction() {
            super(I18n.tr((String)"Configure", (Object[])new Object[0]), "preference", I18n.tr((String)"Configure conflation options", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            ConflationToggleDialog.this.settingsDialog.setVisible(true);
        }
    }

    class DoubleClickHandler
    extends MouseAdapter {
        DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2 || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            ConflationToggleDialog.this.selectAllListSelectedPrimitives();
            AutoScaleAction.zoomTo((Collection)ConflationToggleDialog.this.getAllSelectedPrimitives());
        }
    }
}

