/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.function.IntPredicate;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.plugins.conflation.SimpleMatch;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflationLayer
extends Layer {
    protected SimpleMatchList matches;
    protected IntPredicate isMatchSelected;

    public ConflationLayer(SimpleMatchList matches, IntPredicate isMatchSelected) {
        super(I18n.tr((String)"Conflation", (Object[])new Object[0]));
        this.matches = matches;
        this.isMatchSelected = isMatchSelected;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        Graphics2D g2 = g;
        BasicStroke line = new BasicStroke(3.0f, 1, 1);
        g2.setStroke(line);
        double PHI = Math.toRadians(20.0);
        double cosPHI = Math.cos(PHI);
        double sinPHI = Math.sin(PHI);
        int size = this.matches.size();
        for (int i = 0; i < size; ++i) {
            SimpleMatch match = this.matches.get(i);
            if (this.isMatchSelected.test(i)) {
                g2.setColor(Color.blue);
            } else {
                g2.setColor(Color.cyan);
            }
            OsmPrimitive reference = match.getReferenceObject();
            OsmPrimitive subject = match.getSubjectObject();
            if (reference == null || subject == null) continue;
            GeneralPath path = new GeneralPath();
            Point p1 = mv.getPoint(ConflationUtils.getCenter(subject));
            Point p2 = mv.getPoint(ConflationUtils.getCenter(reference));
            path.moveTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
            double segmentLength = p1.distance(p2);
            if (segmentLength != 0.0) {
                double l = (10.0 + (double)line.getLineWidth()) / segmentLength;
                double sx = l * (double)(p1.x - p2.x);
                double sy = l * (double)(p1.y - p2.y);
                path.moveTo((double)p2.x + cosPHI * sx - sinPHI * sy, (double)p2.y + sinPHI * sx + cosPHI * sy);
                path.lineTo(p2.x, p2.y);
                path.lineTo((double)p2.x + cosPHI * sx + sinPHI * sy, (double)p2.y - sinPHI * sx + cosPHI * sy);
            }
            g2.draw(path);
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"dialogs", (String)"conflation");
    }

    public String getToolTipText() {
        return "Conflation tool tip text goes here";
    }

    public void mergeFrom(Layer layer) {
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (SimpleMatch match : this.matches) {
            OsmPrimitive reference = match.getReferenceObject();
            OsmPrimitive subject = match.getSubjectObject();
            if (reference != null && reference instanceof Node) {
                v.visit((Node)reference);
            }
            if (subject == null || !(subject instanceof Node)) continue;
            v.visit((Node)subject);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public void setMatches(SimpleMatchList matches) {
        this.matches = matches;
    }
}

