/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;

public class IndexedFeatureCollection
extends FeatureCollectionWrapper {
    private SpatialIndex spatialIndex;

    public IndexedFeatureCollection(FeatureCollection fc) {
        this(fc, (SpatialIndex)new STRtree(10));
    }

    public IndexedFeatureCollection(FeatureCollection fc, SpatialIndex spatialIndex) {
        super(fc);
        this.spatialIndex = spatialIndex;
        this.createIndex();
    }

    @Override
    public void add(Feature feature) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public void remove(Feature feature) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public List<Feature> query(Envelope env) {
        List candidate = this.spatialIndex.query(env);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Feature f : candidate) {
            if (!env.intersects(f.getGeometry().getEnvelopeInternal())) continue;
            result.add(f);
        }
        return result;
    }

    private void createIndex() {
        for (Feature f : this) {
            this.spatialIndex.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
    }

    @Override
    public void addAll(Collection<? extends Feature> features) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public Collection<Feature> remove(Envelope env) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public void removeAll(Collection<Feature> features) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }
}

