/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;

public class AttributeType {
    private static Map<String, AttributeType> nameToAttributeTypeMap = new HashMap<String, AttributeType>();
    public static final AttributeType STRING = new AttributeType("STRING", String.class);
    public static final AttributeType GEOMETRY = new AttributeType("GEOMETRY", Geometry.class);
    public static final AttributeType INTEGER = new AttributeType("INTEGER", Integer.class);
    public static final AttributeType DATE = new AttributeType("DATE", Date.class);
    public static final AttributeType DOUBLE = new AttributeType("DOUBLE", Double.class);
    public static final AttributeType OBJECT = new AttributeType("OBJECT", Object.class);
    private String name;
    private Class<?> javaClass;

    public static Collection<AttributeType> allTypes() {
        return nameToAttributeTypeMap.values();
    }

    private AttributeType(String name, Class<?> javaClass) {
        this.name = name;
        this.javaClass = javaClass;
        nameToAttributeTypeMap.put(name, this);
    }

    public String toString() {
        return this.name;
    }

    public static final AttributeType toAttributeType(String name) {
        AttributeType type = nameToAttributeTypeMap.get(name);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    public Class<?> toJavaClass() {
        return this.javaClass;
    }

    public static AttributeType toAttributeType(Class<?> javaClass) {
        for (AttributeType type : AttributeType.allTypes()) {
            if (type.toJavaClass() != javaClass) continue;
            return type;
        }
        return null;
    }
}

