/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import org.locationtech.jts.geom.Geometry;

public abstract class AbstractBasicFeature
implements Feature {
    private FeatureSchema schema;
    private int id = FeatureUtil.nextID();

    @Override
    public void setSchema(FeatureSchema schema) {
        this.schema = schema;
    }

    public AbstractBasicFeature(FeatureSchema featureSchema) {
        this.schema = featureSchema;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setAttribute(String attributeName, Object newAttribute) {
        this.setAttribute(this.schema.getAttributeIndex(attributeName), newAttribute);
    }

    @Override
    public void setGeometry(Geometry geometry) {
        this.setAttribute(this.schema.getGeometryIndex(), (Object)geometry);
    }

    @Override
    public Object getAttribute(String name) {
        return this.getAttribute(this.schema.getAttributeIndex(name));
    }

    @Override
    public String getString(int attributeIndex) {
        Object result = this.getAttribute(attributeIndex);
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    @Override
    public int getInteger(int attributeIndex) {
        return (Integer)this.getAttribute(attributeIndex);
    }

    @Override
    public double getDouble(int attributeIndex) {
        return (Double)this.getAttribute(attributeIndex);
    }

    @Override
    public String getString(String attributeName) {
        return this.getString(this.schema.getAttributeIndex(attributeName));
    }

    @Override
    public Geometry getGeometry() {
        return (Geometry)this.getAttribute(this.schema.getGeometryIndex());
    }

    @Override
    public FeatureSchema getSchema() {
        return this.schema;
    }

    @Override
    public Object clone() {
        return this.clone(true);
    }

    @Override
    public Feature clone(boolean deep) {
        BasicFeature clone = new BasicFeature(this.schema);
        for (int i = 0; i < this.schema.getAttributeCount(); ++i) {
            if (this.schema.getAttributeType(i) == AttributeType.GEOMETRY) {
                clone.setAttribute(i, (Object)(deep ? this.getGeometry().copy() : this.getGeometry()));
                continue;
            }
            clone.setAttribute(i, this.getAttribute(i));
        }
        return clone;
    }

    @Override
    public int compareTo(Feature o) {
        return this.getGeometry().compareTo((Object)o.getGeometry());
    }
}

