/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.plugin.conflate.polygonmatch;

import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

public class MyValidatingTextField
extends ValidatingTextField {
    public static final ValidatingTextField.Validator NON_NEGATIVE_DOUBLE_VALIDATOR = new ValidatingTextField.Validator(){

        @Override
        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                return Double.parseDouble("0" + text.trim() + "0") >= 0.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final ValidatingTextField.Validator NON_NEGATIVE_INTEGER_VALIDATOR = new ValidatingTextField.Validator(){

        @Override
        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                return Integer.parseInt(text.trim()) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };

    public MyValidatingTextField(String text, int columns, ValidatingTextField.Validator validator, String emptyStringReplacement) {
        this(text, columns, validator, emptyStringReplacement, 4);
    }

    public MyValidatingTextField(String text, int columns, ValidatingTextField.Validator validator, final String emptyStringReplacement, int alignment) {
        super(text, columns, validator);
        this.setHorizontalAlignment(alignment);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (MyValidatingTextField.this.getText().trim().length() == 0) {
                    MyValidatingTextField.this.setText(emptyStringReplacement);
                }
            }
        });
        this.setText(text);
    }

    @Override
    public double getDouble() {
        try {
            return Double.parseDouble(this.getText().trim());
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble("0" + this.getText().trim());
            }
            catch (NumberFormatException e2) {
                try {
                    return Double.parseDouble(this.getText().trim() + "0");
                }
                catch (NumberFormatException e3) {
                    return Double.parseDouble("0" + this.getText().trim() + "0");
                }
            }
        }
    }

    public static class GreaterThanValidator
    implements ValidatingTextField.Validator {
        private double threshold;

        public GreaterThanValidator(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean isValid(String text) {
            return text.trim().length() == 0 || Double.parseDouble(text.trim()) > this.threshold;
        }
    }

    public static class CompositeValidator
    implements ValidatingTextField.Validator {
        private ValidatingTextField.Validator[] validators;

        public CompositeValidator(ValidatingTextField.Validator[] validators) {
            this.validators = validators;
        }

        @Override
        public boolean isValid(String text) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (this.validators[i].isValid(text)) continue;
                return false;
            }
            return true;
        }
    }
}

