/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.locationtech.jts.util.Assert;

public class WeightedMatcher
implements FeatureMatcher {
    private final Map<FeatureMatcher, Double> matcherToWeightMap = new HashMap<FeatureMatcher, Double>();

    public WeightedMatcher(Object ... matchersAndWeights) {
        Objects.requireNonNull(matchersAndWeights);
        Assert.isTrue((matchersAndWeights.length % 2 == 0 ? 1 : 0) != 0);
        for (int i = 0; i < matchersAndWeights.length; i += 2) {
            this.add((FeatureMatcher)matchersAndWeights[i + 1], ((Number)matchersAndWeights[i]).doubleValue());
        }
    }

    private void add(FeatureMatcher matcher, double weight) {
        Assert.isTrue((weight >= 0.0 ? 1 : 0) != 0);
        if (weight == 0.0) {
            return;
        }
        this.matcherToWeightMap.put(matcher, weight);
    }

    @Override
    public Matches match(Feature target, FeatureCollection candidates) {
        if (this.weightTotal() == 0.0) {
            return new Matches(candidates.getFeatureSchema());
        }
        Map<FeatureMatcher, Matches> matcherToMatchesMap = this.matcherToMatchesMap(target, candidates);
        Map<Feature, Double> featureToScoreMap = this.featureToScoreMap(matcherToMatchesMap);
        return this.toMatches(featureToScoreMap, candidates.getFeatureSchema());
    }

    private Matches toMatches(Map<Feature, Double> featureToScoreMap, FeatureSchema schema) {
        Matches matches = new Matches(schema);
        featureToScoreMap.forEach(matches::add);
        return matches;
    }

    private Map<FeatureMatcher, Matches> matcherToMatchesMap(Feature feature, FeatureCollection candidates) {
        HashMap<FeatureMatcher, Matches> matcherToMatchesMap = new HashMap<FeatureMatcher, Matches>();
        for (FeatureMatcher matcher : this.matcherToWeightMap.keySet()) {
            if (this.normalizedWeight(matcher) == 0.0) continue;
            matcherToMatchesMap.put(matcher, matcher.match(feature, candidates));
        }
        return matcherToMatchesMap;
    }

    private Map<Feature, Double> featureToScoreMap(Map<FeatureMatcher, Matches> matcherToMatchesMap) {
        TreeMap<Feature, Double> featureToScoreMap = new TreeMap<Feature, Double>();
        matcherToMatchesMap.forEach((matcher, matches) -> this.addToFeatureToScoreMap((Matches)matches, (FeatureMatcher)matcher, (Map<Feature, Double>)featureToScoreMap));
        return featureToScoreMap;
    }

    private void addToFeatureToScoreMap(Matches matches, FeatureMatcher matcher, Map<Feature, Double> featureToScoreMap) {
        for (Map.Entry<Feature, Double> entry : matches.entrySet()) {
            double score = entry.getValue() * this.normalizedWeight(matcher);
            featureToScoreMap.compute(entry.getKey(), (key, value) -> value == null ? score : value + score);
        }
    }

    private double normalizedWeight(FeatureMatcher matcher) {
        return this.matcherToWeightMap.get(matcher) / this.weightTotal();
    }

    private double weightTotal() {
        return this.matcherToWeightMap.values().stream().mapToDouble(Double::doubleValue).sum();
    }
}

