/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.AreaFilterFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.DisambiguationMatch;
import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;

public class TargetUnioningFCMatchFinder
implements FCMatchFinder {
    private FCMatchFinder matchFinder;
    private int maxCompositeSize;
    private List<Feature> lastTargetConstituents;
    private List<Integer> lastUnionIDs;

    public TargetUnioningFCMatchFinder(int maxCompositeSize, FCMatchFinder matchFinder) {
        this.maxCompositeSize = maxCompositeSize;
        this.matchFinder = matchFinder;
    }

    @Override
    public Map<Feature, Matches> match(FeatureCollection targetFC, FeatureCollection candidateFC, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        FeatureCollection compositeTargetFC = this.createCompositeFC(targetFC, monitor);
        Map<Feature, Matches> compositeTargetFeatureToMatchesMap = this.matchFinder.match(compositeTargetFC, candidateFC, monitor);
        compositeTargetFeatureToMatchesMap = this.disambiguateCompositeTargetConstituents(compositeTargetFeatureToMatchesMap, candidateFC.getFeatureSchema(), monitor);
        this.createUnionIDs(compositeTargetFeatureToMatchesMap, monitor);
        Map<Feature, Matches> filteredTargetToMatchesMap = this.splitCompositeTargets(compositeTargetFeatureToMatchesMap, monitor);
        Map<Feature, Matches> targetToMatchesMap = AreaFilterFCMatchFinder.blankTargetToMatchesMap(targetFC.getFeatures(), candidateFC.getFeatureSchema());
        targetToMatchesMap.putAll(filteredTargetToMatchesMap);
        return targetToMatchesMap;
    }

    private void createUnionIDs(final Map<Feature, Matches> compositeTargetFeatureToMatchesMap, TaskMonitor monitor) {
        monitor.report("Creating union IDs");
        ArrayList<Feature> compositeTargets = new ArrayList<Feature>(compositeTargetFeatureToMatchesMap.keySet());
        Collections.sort(compositeTargets, new Comparator<Feature>(){

            @Override
            public int compare(Feature o1, Feature o2) {
                double s2;
                double s1 = ((Matches)compositeTargetFeatureToMatchesMap.get(o1)).getTopScore();
                return s1 < (s2 = ((Matches)compositeTargetFeatureToMatchesMap.get(o2)).getTopScore()) ? -1 : (s1 > s2 ? 1 : 0);
            }
        });
        this.lastTargetConstituents = new ArrayList<Feature>();
        this.lastUnionIDs = new ArrayList<Integer>();
        int unionID = 0;
        for (int i = 0; i < compositeTargets.size(); ++i) {
            monitor.report(i + 1, compositeTargets.size(), "unions");
            CompositeFeature compositeTarget = (CompositeFeature)compositeTargets.get(i);
            if (compositeTarget.getFeatures().size() == 1) continue;
            ++unionID;
            for (Feature targetConstituent : compositeTarget.getFeatures()) {
                this.lastTargetConstituents.add(targetConstituent);
                this.lastUnionIDs.add(unionID);
            }
        }
    }

    protected FeatureCollection createCompositeFC(FeatureCollection fc, TaskMonitor monitor) {
        FeatureDataset compositeFC = new FeatureDataset(fc.getFeatureSchema());
        Set<CompositeFeature> composites = this.createCompositeSet(fc, monitor);
        this.add(composites, compositeFC, monitor);
        return new IndexedFeatureCollection(compositeFC);
    }

    protected Map<Feature, Matches> disambiguateCompositeTargetConstituents(Map<Feature, Matches> compositeTargetToMatchesMap, FeatureSchema candidateSchema, TaskMonitor monitor) {
        ArrayList<Feature> targetConstituentsEncountered = new ArrayList<Feature>();
        ArrayList<Feature> compositeTargets = new ArrayList<Feature>();
        ArrayList<Feature> candidates = new ArrayList<Feature>();
        ArrayList<Double> scores = new ArrayList<Double>();
        SortedSet<DisambiguationMatch> matchSet = DisambiguationMatch.createDisambiguationMatches(compositeTargetToMatchesMap, monitor);
        monitor.report("Discarding inferior composite matches");
        int j = 0;
        block0: for (DisambiguationMatch match : matchSet) {
            monitor.report(++j, matchSet.size(), "matches");
            for (Feature targetConstituent : ((CompositeFeature)match.getTarget()).getFeatures()) {
                if (!targetConstituentsEncountered.contains(targetConstituent)) continue;
                continue block0;
            }
            compositeTargets.add(match.getTarget());
            candidates.add(match.getCandidate());
            scores.add(match.getScore());
            targetConstituentsEncountered.addAll(((CompositeFeature)match.getTarget()).getFeatures());
        }
        HashMap<Feature, Matches> newMap = new HashMap<Feature, Matches>();
        for (int i = 0; i < compositeTargets.size(); ++i) {
            Matches matches = new Matches(candidateSchema);
            matches.add((Feature)candidates.get(i), (Double)scores.get(i));
            newMap.put((Feature)compositeTargets.get(i), matches);
        }
        return newMap;
    }

    private List<Feature> featuresWithCommonEdge(Feature feature, FeatureCollection fc) {
        ArrayList<Feature> featuresWithCommonEdge = new ArrayList<Feature>();
        List<Feature> candidates = fc.query(feature.getGeometry().getEnvelopeInternal());
        for (Feature candidate : candidates) {
            if (feature != candidate && !this.shareEdge(feature.getGeometry(), candidate.getGeometry())) continue;
            featuresWithCommonEdge.add(candidate);
        }
        return featuresWithCommonEdge;
    }

    protected boolean shareEdge(Geometry a, Geometry b) {
        Set<Edge> aEdges = this.edges(a);
        Set<Edge> bEdges = this.edges(b);
        for (Edge bEdge : bEdges) {
            if (!aEdges.contains(bEdge)) continue;
            return true;
        }
        return false;
    }

    private Set<Edge> edges(Geometry g) {
        TreeSet<Edge> edges = new TreeSet<Edge>();
        for (Coordinate[] coordinates : CoordinateArrays.toCoordinateArrays(g, false)) {
            for (int j = 1; j < coordinates.length; ++j) {
                edges.add(new Edge(coordinates[j], coordinates[j - 1]));
            }
        }
        return edges;
    }

    protected Map<Feature, Matches> splitCompositeTargets(Map<Feature, Matches> compositeToMatchesMap, TaskMonitor monitor) {
        monitor.report("Splitting composites");
        int compositesProcessed = 0;
        int totalComposites = compositeToMatchesMap.size();
        HashMap<Feature, Matches> newMap = new HashMap<Feature, Matches>();
        Iterator<Feature> i = compositeToMatchesMap.keySet().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            CompositeFeature composite = (CompositeFeature)i.next();
            monitor.report(++compositesProcessed, totalComposites, "composites");
            Matches matches = compositeToMatchesMap.get(composite);
            for (Feature targetConstituent : composite.getFeatures()) {
                Assert.isTrue((!newMap.containsKey(targetConstituent) ? 1 : 0) != 0);
                newMap.put(targetConstituent, matches.clone());
            }
        }
        return newMap;
    }

    private Set<CompositeFeature> createCompositeSet(FeatureCollection fc, TaskMonitor monitor) {
        monitor.report("Creating composites of adjacent features");
        int featuresProcessed = 0;
        int totalFeatures = fc.getFeatures().size();
        HashSet<CompositeFeature> composites = new HashSet<CompositeFeature>();
        Iterator<Feature> i = fc.getFeatures().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature feature = i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features");
            List<Feature> featuresWithCommonEdge = this.featuresWithCommonEdge(feature, fc);
            Iterator<List<Feature>> j = CollectionUtil.combinations(featuresWithCommonEdge, this.maxCompositeSize, feature).iterator();
            while (j.hasNext() && !monitor.isCancelRequested()) {
                List<Feature> combination = j.next();
                composites.add(new CompositeFeature(fc.getFeatureSchema(), combination));
            }
        }
        return composites;
    }

    private void add(Collection<? extends Feature> features, FeatureCollection fc, TaskMonitor monitor) {
        monitor.report("Building feature-collection");
        fc.addAll(features);
    }

    public Integer getUnionID(Feature target) {
        int i = this.lastTargetConstituents.indexOf(target);
        if (i == -1) {
            return null;
        }
        return this.lastUnionIDs.get(i);
    }

    public static class CompositeFeature
    extends BasicFeature {
        private List<Feature> features;
        private int hashCode;

        public CompositeFeature(FeatureSchema schema, List<Feature> features) {
            super(schema);
            this.features = features;
            Geometry union = features.get(0).getGeometry();
            this.hashCode = features.get(0).hashCode();
            for (int i = 1; i < features.size(); ++i) {
                Feature feature = features.get(i);
                union = union.union(feature.getGeometry());
                this.hashCode = Math.min(this.hashCode, feature.hashCode());
            }
            this.setGeometry(union);
        }

        public List<Feature> getFeatures() {
            return this.features;
        }

        public boolean equals(Object obj) {
            Assert.isTrue((boolean)(obj instanceof CompositeFeature), (String)obj.getClass().toString());
            CompositeFeature other = (CompositeFeature)obj;
            if (this.features.size() != other.features.size()) {
                return false;
            }
            for (Feature myFeature : this.features) {
                if (other.features.contains(myFeature)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class Edge
    implements Comparable<Edge> {
        private Coordinate p0;
        private Coordinate p1;

        public Edge(Coordinate a, Coordinate b) {
            if (a.compareTo(b) < 1) {
                this.p0 = a;
                this.p1 = b;
            } else {
                this.p0 = b;
                this.p1 = a;
            }
        }

        @Override
        public int compareTo(Edge other) {
            int result = this.p0.compareTo(other.p0);
            if (result != 0) {
                return result;
            }
            return this.p1.compareTo(other.p1);
        }
    }
}

