/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;

public class ScoreStretcher
implements FeatureMatcher {
    private double minScore;
    private double maxScore;

    public ScoreStretcher(double minScore, double maxScore) {
        this.minScore = minScore;
        this.maxScore = maxScore;
    }

    @Override
    public Matches match(Feature target, FeatureCollection candidates) {
        Matches oldMatches = (Matches)candidates;
        Matches newMatches = new Matches(candidates.getFeatureSchema());
        for (int i = 0; i < oldMatches.size(); ++i) {
            newMatches.add(oldMatches.getFeature(i), this.convert(oldMatches.getScore(i)));
        }
        return newMatches;
    }

    private double convert(double oldScore) {
        double x = this.minScore;
        double y = 0.0;
        double u = this.maxScore;
        double v = 1.0;
        double m = (y - v) / (x - u);
        double b = y - m * x;
        return Math.min(1.0, Math.max(0.0, m * oldScore + b));
    }
}

