/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.locationtech.jts.util.Assert;

public class OneToOneFCMatchFinder
implements FCMatchFinder {
    private FCMatchFinder matchFinder;

    public OneToOneFCMatchFinder(FCMatchFinder matchFinder) {
        this.matchFinder = matchFinder;
    }

    @Override
    public Map<Feature, Matches> match(FeatureCollection targetFC, FeatureCollection candidateFC, TaskMonitor monitor) {
        Map<Feature, Matches> targetToMatchesMap = this.matchFinder.match(targetFC, candidateFC, monitor);
        monitor.allowCancellationRequests();
        monitor.report("Finding best forward matches");
        Map<Feature, Matches> bestForwardMatches = this.filterMatches(targetToMatchesMap, monitor);
        monitor.report("Finding best reverse matches");
        Map<Feature, Matches> bestReverseMatches = this.filterMatches(this.invert(targetToMatchesMap, monitor), monitor);
        monitor.report("Finding common best matches");
        return this.commonMatches(bestForwardMatches, this.invert(bestReverseMatches, monitor), monitor);
    }

    private Map<Feature, Matches> commonMatches(Map<Feature, Matches> featureToMatchesMap1, Map<Feature, Matches> featureToMatchesMap2, TaskMonitor monitor) {
        int featuresProcessed = 0;
        int totalFeatures = featureToMatchesMap1.size();
        HashMap<Feature, Matches> commonMatches = new HashMap<Feature, Matches>();
        Iterator<Feature> i = featureToMatchesMap1.keySet().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature key1 = i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features");
            if (!featureToMatchesMap2.containsKey(key1)) continue;
            Matches matches1 = featureToMatchesMap1.get(key1);
            Matches matches2 = featureToMatchesMap2.get(key1);
            if (matches1.getTopMatch() != matches2.getTopMatch()) continue;
            Assert.isTrue((matches1.getTopScore() == matches2.getTopScore() ? 1 : 0) != 0);
            commonMatches.put(key1, matches1);
        }
        return commonMatches;
    }

    private Map<Feature, Matches> filterMatches(Map<Feature, Matches> featureToMatchesMap, TaskMonitor monitor) {
        int featuresProcessed = 0;
        int totalFeatures = featureToMatchesMap.size();
        HashMap<Feature, Matches> newMap = new HashMap<Feature, Matches>();
        if (featureToMatchesMap.isEmpty()) {
            return newMap;
        }
        Iterator<Feature> i = featureToMatchesMap.keySet().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature feature = i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features filtered");
            Matches oldMatches = featureToMatchesMap.get(feature);
            if (oldMatches.isEmpty()) continue;
            Matches newMatches = new Matches(oldMatches.getFeatureSchema());
            newMatches.add(oldMatches.getTopMatch(), oldMatches.getTopScore());
            newMap.put(feature, newMatches);
        }
        return newMap;
    }

    protected Map<Feature, Matches> invert(Map<Feature, Matches> featureToMatchesMap, TaskMonitor monitor) {
        int featuresProcessed = 0;
        int totalFeatures = featureToMatchesMap.size();
        HashMap<Feature, Matches> newMap = new HashMap<Feature, Matches>();
        if (featureToMatchesMap.isEmpty()) {
            return newMap;
        }
        Iterator<Feature> i = featureToMatchesMap.keySet().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature oldKey = i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features inverted");
            Matches oldMatches = featureToMatchesMap.get(oldKey);
            for (int j = 0; j < oldMatches.size(); ++j) {
                Feature newKey = oldMatches.getFeature(j);
                Matches newMatches = (Matches)newMap.get(newKey);
                if (newMatches == null) {
                    newMatches = new Matches(oldKey.getSchema());
                }
                newMatches.add(oldKey, oldMatches.getScore(j));
                newMap.put(newKey, newMatches);
            }
        }
        return newMap;
    }
}

