/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;

public class MatcherUtil {
    public static void alignByOutlineCentreOfMass(Geometry g) {
        MatcherUtil.align(g, MatcherUtil.outlineCentreOfMass(g));
    }

    public static void align(Geometry g, Coordinate c) {
        final Coordinate move = CoordUtil.subtract(new Coordinate(0.0, 0.0), c);
        g.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x += move.x;
                coordinate.y += move.y;
            }
        });
    }

    public static Coordinate outlineCentreOfMass(Geometry g) {
        Coordinate weightedSum = new Coordinate();
        double totalLength = 0.0;
        List<Coordinate[]> coordArrays = CoordinateArrays.toCoordinateArrays(g, false);
        for (Coordinate[] coords : coordArrays) {
            for (int j = 1; j < coords.length; ++j) {
                double length = coords[j - 1].distance(coords[j]);
                totalLength += length;
                weightedSum = CoordUtil.add(weightedSum, CoordUtil.multiply(length, CoordUtil.average(coords[j - 1], coords[j])));
            }
        }
        return CoordUtil.divide(weightedSum, totalLength);
    }

    public static double toScoreFromSymDiffArea(double targetArea, double candidateArea, double symDiffArea) {
        return 1.0 - symDiffArea / (targetArea + candidateArea);
    }
}

