/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import org.locationtech.jts.util.Assert;

public class Histogram {
    private double[] bins;

    public Histogram(int binCount) {
        this.bins = new double[binCount];
    }

    public void addToBinScore(int i, double score) {
        int n = i;
        this.bins[n] = this.bins[n] + score;
    }

    public double getBinScore(int i) {
        return this.bins[i];
    }

    public double getTotalScore() {
        double total = 0.0;
        for (int i = 0; i < this.getBinCount(); ++i) {
            total += this.getBinScore(i);
        }
        return total;
    }

    public int getBinCount() {
        return this.bins.length;
    }

    public double symDiff(Histogram other) {
        Assert.isTrue((this.getBinCount() == other.getBinCount() ? 1 : 0) != 0);
        double symDiff = 0.0;
        for (int i = 0; i < this.getBinCount(); ++i) {
            symDiff += Math.abs(this.getBinScore(i) - other.getBinScore(i));
        }
        return symDiff;
    }

    public void add(Histogram other) {
        Assert.isTrue((this.getBinCount() == other.getBinCount() ? 1 : 0) != 0);
        for (int i = 0; i < this.getBinCount(); ++i) {
            this.addToBinScore(i, other.getBinScore(i));
        }
    }
}

