/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.IndependentCandidateMatcher;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;

public class CompactnessMatcher
extends IndependentCandidateMatcher {
    @Override
    public double match(Geometry target, Geometry candidate) {
        double score = 1.0 - Math.abs(this.characteristic(target) - this.characteristic(candidate));
        Assert.isTrue((score >= 0.0 ? 1 : 0) != 0);
        Assert.isTrue((score <= 1.0 ? 1 : 0) != 0);
        return score;
    }

    protected double characteristic(Geometry g) {
        if (g.getLength() == 0.0) {
            return 1.0;
        }
        return Math.PI * 4 * g.getArea() / Math.pow(g.getLength(), 2.0);
    }
}

