/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jcs.conflate.polygonmatch.OneToOneFCMatchFinder;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;

public class CombinatorialFCMatchFinder
implements FCMatchFinder {
    private FCMatchFinder matchFinder;
    private int maxCompositeSize;

    public CombinatorialFCMatchFinder(int maxCompositeSize, FCMatchFinder matchFinder) {
        this.maxCompositeSize = maxCompositeSize;
        this.matchFinder = new OneToOneFCMatchFinder(matchFinder);
    }

    public Map<Feature, Matches> match(IndexedFeatureCollection targetFC, IndexedFeatureCollection candidateFC, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        FeatureDataset compositeTargetFC = new FeatureDataset(targetFC.getFeatureSchema());
        CollectionMap<Feature, CompositeFeature> constituentToCompositesMap = new CollectionMap<Feature, CompositeFeature>();
        this.createComposites(targetFC, constituentToCompositesMap, compositeTargetFC, monitor);
        Map<Feature, Matches> targetFeatureToMatchesMap = this.matchFinder.match(new IndexedFeatureCollection(compositeTargetFC), candidateFC, monitor);
        this.deleteInferiorComposites(targetFeatureToMatchesMap, constituentToCompositesMap, monitor);
        return this.splitComposites(targetFeatureToMatchesMap, monitor);
    }

    protected void createComposites(FeatureCollection fc, CollectionMap<Feature, CompositeFeature> constituentToCompositesMap, FeatureCollection compositeFC, TaskMonitor monitor) {
        Assert.isTrue((boolean)constituentToCompositesMap.isEmpty());
        Assert.isTrue((boolean)compositeFC.isEmpty());
        Set<CompositeFeature> composites = this.createCompositeSet(fc, monitor);
        this.add(composites, constituentToCompositesMap, monitor);
        this.add(composites, compositeFC, monitor);
    }

    protected void deleteInferiorComposites(Map<CompositeFeature, Matches> compositeToMatchesMap, CollectionMap<Feature, CompositeFeature> constituentToCompositesMap, TaskMonitor monitor) {
        monitor.report("Discarding inferior composites");
        int featuresProcessed = 0;
        int totalFeatures = constituentToCompositesMap.size();
        Iterator<Feature> i = constituentToCompositesMap.keySet().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature constituent = i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features");
            Collection<CompositeFeature> composites = constituentToCompositesMap.getItems(constituent);
            Assert.isTrue((!composites.isEmpty() ? 1 : 0) != 0);
            double bestScore = -1.0;
            CompositeFeature bestComposite = null;
            Matches bestMatches = null;
            for (CompositeFeature composite : composites) {
                Matches matches = compositeToMatchesMap.get(composite);
                if (matches == null || !(matches.getTopScore() > bestScore)) continue;
                bestScore = matches.getTopScore();
                bestComposite = composite;
                bestMatches = matches;
            }
            CollectionUtil.removeKeys(composites, compositeToMatchesMap);
            if (bestMatches == null) continue;
            compositeToMatchesMap.put(bestComposite, bestMatches);
        }
    }

    protected List<Feature> featuresWithCommonEdge(Feature feature, FeatureCollection fc) {
        ArrayList<Feature> featuresWithCommonEdge = new ArrayList<Feature>();
        List<Feature> candidates = fc.query(feature.getGeometry().getEnvelopeInternal());
        for (Feature candidate : candidates) {
            if (feature != candidate && !this.shareEdge(feature.getGeometry(), candidate.getGeometry())) continue;
            featuresWithCommonEdge.add(candidate);
        }
        return featuresWithCommonEdge;
    }

    protected boolean shareEdge(Geometry a, Geometry b) {
        Set<Edge> aEdges = this.edges(a);
        Set<Edge> bEdges = this.edges(b);
        for (Edge bEdge : bEdges) {
            if (!aEdges.contains(bEdge)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Feature, Matches> match(FeatureCollection targetFC, FeatureCollection candidateFC, TaskMonitor monitor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Set<Edge> edges(Geometry g) {
        TreeSet<Edge> edges = new TreeSet<Edge>();
        for (Coordinate[] coordinates : CoordinateArrays.toCoordinateArrays(g, false)) {
            for (int j = 1; j < coordinates.length; ++j) {
                edges.add(new Edge(coordinates[j], coordinates[j - 1]));
            }
        }
        return edges;
    }

    protected Map<Feature, Matches> splitComposites(Map<CompositeFeature, Matches> compositeToMatchesMap, TaskMonitor monitor) {
        monitor.report("Splitting composites");
        int compositesProcessed = 0;
        int totalComposites = compositeToMatchesMap.size();
        HashMap<Feature, Matches> newMap = new HashMap<Feature, Matches>();
        Iterator<CompositeFeature> i = compositeToMatchesMap.keySet().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            CompositeFeature composite = i.next();
            monitor.report(++compositesProcessed, totalComposites, "composites");
            Matches matches = compositeToMatchesMap.get(composite);
            Assert.isTrue((1 == matches.size() ? 1 : 0) != 0);
            for (Feature constituent : composite.getFeatures()) {
                Assert.isTrue((!newMap.containsKey(constituent) ? 1 : 0) != 0);
                Matches matchesCopy = new Matches(matches.getFeatureSchema());
                matchesCopy.add(matches.getTopMatch(), matches.getTopScore());
                newMap.put(constituent, matchesCopy);
            }
        }
        return newMap;
    }

    private Set<CompositeFeature> createCompositeSet(FeatureCollection fc, TaskMonitor monitor) {
        monitor.report("Creating composites of adjacent features");
        int featuresProcessed = 0;
        int totalFeatures = fc.getFeatures().size();
        HashSet<CompositeFeature> composites = new HashSet<CompositeFeature>();
        Iterator<Feature> i = fc.getFeatures().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature feature = i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features");
            List<Feature> featuresWithCommonEdge = this.featuresWithCommonEdge(feature, fc);
            Iterator<List<Feature>> j = CollectionUtil.combinations(featuresWithCommonEdge, this.maxCompositeSize, feature).iterator();
            while (j.hasNext() && !monitor.isCancelRequested()) {
                List<Feature> combination = j.next();
                composites.add(new CompositeFeature(fc.getFeatureSchema(), combination));
            }
        }
        return composites;
    }

    private void add(Set<CompositeFeature> composites, CollectionMap<Feature, CompositeFeature> constituentToCompositesMap, TaskMonitor monitor) {
        monitor.report("Creating feature-to-composite map");
        int compositesProcessed = 0;
        int totalComposites = composites.size();
        Iterator<CompositeFeature> i = composites.iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            CompositeFeature composite = i.next();
            monitor.report(++compositesProcessed, totalComposites, "composites");
            Iterator<Feature> j = composite.getFeatures().iterator();
            while (j.hasNext() && !monitor.isCancelRequested()) {
                Feature constituent = j.next();
                constituentToCompositesMap.addItem(constituent, composite);
            }
        }
    }

    private void add(Collection<CompositeFeature> features, FeatureCollection fc, TaskMonitor monitor) {
        monitor.report("Building feature-collection");
        fc.addAll(features);
    }

    public static class CompositeFeature
    extends BasicFeature {
        private List<Feature> features;
        private int hashCode;

        public CompositeFeature(FeatureSchema schema, List<Feature> features) {
            super(schema);
            this.features = features;
            Geometry union = features.get(0).getGeometry();
            this.hashCode = features.get(0).hashCode();
            for (int i = 1; i < features.size(); ++i) {
                Feature feature = features.get(i);
                union = union.union(feature.getGeometry());
                this.hashCode = Math.min(this.hashCode, feature.hashCode());
            }
            this.setGeometry(union);
        }

        public List<Feature> getFeatures() {
            return this.features;
        }

        public boolean equals(Object obj) {
            Assert.isTrue((boolean)(obj instanceof CompositeFeature), (String)obj.getClass().toString());
            CompositeFeature other = (CompositeFeature)obj;
            if (this.features.size() != other.features.size()) {
                return false;
            }
            for (Feature myFeature : this.features) {
                if (other.features.contains(myFeature)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class Edge
    implements Comparable<Edge> {
        private Coordinate p0;
        private Coordinate p1;

        public Edge(Coordinate a, Coordinate b) {
            if (a.compareTo(b) < 1) {
                this.p0 = a;
                this.p1 = b;
            } else {
                this.p0 = b;
                this.p1 = a;
            }
        }

        @Override
        public int compareTo(Edge other) {
            int result = this.p0.compareTo(other.p0);
            if (result != 0) {
                return result;
            }
            return this.p1.compareTo(other.p1);
        }
    }
}

