/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.algorithm;

import com.vividsolutions.jcs.algorithm.EuclideanDistanceToPoint;
import com.vividsolutions.jcs.algorithm.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;

public class VertexHausdorffDistance {
    PointPairDistance ptDist = new PointPairDistance();

    public VertexHausdorffDistance(Geometry g0, Geometry g1) {
        this.compute(g0, g1);
    }

    public VertexHausdorffDistance(LineSegment seg0, LineSegment seg1) {
        this.compute(seg0, seg1);
    }

    public double distance() {
        return this.ptDist.getDistance();
    }

    public Coordinate[] getCoordinates() {
        return this.ptDist.getCoordinates();
    }

    private void compute(LineSegment seg0, LineSegment seg1) {
        this.computeMaxPointDistance(seg0, seg1, this.ptDist);
        this.computeMaxPointDistance(seg1, seg0, this.ptDist);
    }

    private void computeMaxPointDistance(LineSegment seg0, LineSegment seg1, PointPairDistance ptDist) {
        Coordinate closestPt0 = seg0.closestPoint(seg1.p0);
        ptDist.setMaximum(closestPt0, seg1.p0);
        Coordinate closestPt1 = seg0.closestPoint(seg1.p1);
        ptDist.setMaximum(closestPt1, seg1.p1);
    }

    private void compute(Geometry g0, Geometry g1) {
        this.computeMaxPointDistance(g0, g1, this.ptDist);
        this.computeMaxPointDistance(g1, g0, this.ptDist);
    }

    private void computeMaxPointDistance(Geometry pointGeom, Geometry geom, PointPairDistance ptDist) {
        MaxPointDistanceFilter distFilter = new MaxPointDistanceFilter(geom);
        pointGeom.apply((CoordinateFilter)distFilter);
        ptDist.setMaximum(distFilter.getMaxPointDistance());
    }

    public static class MaxPointDistanceFilter
    implements CoordinateFilter {
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();
        private Geometry geom;

        public MaxPointDistanceFilter(Geometry geom) {
            this.geom = geom;
        }

        public void filter(Coordinate pt) {
            this.minPtDist.initialize();
            EuclideanDistanceToPoint.computeDistance(this.geom, pt, this.minPtDist);
            this.maxPtDist.setMaximum(this.minPtDist);
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }
    }
}

