/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.algorithm;

import com.vividsolutions.jcs.algorithm.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class EuclideanDistanceToPoint {
    private static LineSegment tempSegment = new LineSegment();

    public static void computeDistance(Geometry geom, Coordinate pt, PointPairDistance ptDist) {
        if (geom instanceof LineString) {
            EuclideanDistanceToPoint.computeDistance((LineString)geom, pt, ptDist);
        } else if (geom instanceof Polygon) {
            EuclideanDistanceToPoint.computeDistance((Polygon)geom, pt, ptDist);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry g = gc.getGeometryN(i);
                EuclideanDistanceToPoint.computeDistance(g, pt, ptDist);
            }
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt);
        }
    }

    public static void computeDistance(LineString line, Coordinate pt, PointPairDistance ptDist) {
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            tempSegment.setCoordinates(coords[i], coords[i + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public static void computeDistance(LineSegment segment, Coordinate pt, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    public static void computeDistance(Polygon poly, Coordinate pt, PointPairDistance ptDist) {
        EuclideanDistanceToPoint.computeDistance((LineString)poly.getExteriorRing(), pt, ptDist);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            EuclideanDistanceToPoint.computeDistance((LineString)poly.getInteriorRingN(i), pt, ptDist);
        }
    }
}

