/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui.move;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.maripo.josm.easypresets.data.EasyPresets;
import org.maripo.josm.easypresets.data.PresetsEntry;
import org.maripo.josm.easypresets.ui.PresetRenderer;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class MoveFolderDialog
extends ExtendedDialog
implements ListSelectionListener {
    private static final long serialVersionUID = -5956713655196705733L;
    PresetsEntry entry;
    EasyPresets parent;
    JLabel alertLabel;
    JList<PresetsEntry> list;
    JButton moveParentButton;
    JButton moveButton;

    public MoveFolderDialog(PresetsEntry entry) throws CloneNotSupportedException {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Organize", (Object[])new Object[0]), new String[0]);
        this.entry = entry;
        this.parent = entry.getParent();
        this.initUI();
    }

    private void initUI() throws CloneNotSupportedException {
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BoxLayout(basePanel, 1));
        basePanel.add(this.getMainPane());
        basePanel.add(this.getButtonPanel());
        this.setContent(basePanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoveFolderDialog.this.toFront();
            }
        });
    }

    private JPanel getMainPane() throws CloneNotSupportedException {
        PresetsEntry[] array;
        EasyPresets groupList = this.parent.clone();
        groupList.removeAllElements();
        for (PresetsEntry ent : array = this.parent.toArray()) {
            if (!(ent instanceof EasyPresets)) continue;
            groupList.addElement(ent);
        }
        this.list = new JList<PresetsEntry>(groupList);
        this.list.setCellRenderer(new PresetRenderer());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        JPanel listPane = new JPanel(new GridBagLayout());
        JScrollPane listScroll = new JScrollPane(this.list);
        listScroll.setPreferredSize(new Dimension(320, 420));
        listPane.add((Component)listScroll, GBC.std());
        this.alertLabel = new JLabel(" ");
        this.alertLabel.setForeground(Color.RED);
        JPanel mainPane = new JPanel(new GridBagLayout());
        mainPane.add((Component)new JLabel(I18n.tr((String)"Please select a destination group.", (Object[])new Object[0])), GBC.eol().fill());
        mainPane.add((Component)listPane, GBC.eol().fill());
        mainPane.add((Component)this.alertLabel, GBC.eol().fill());
        return mainPane;
    }

    private JPanel getButtonPanel() {
        this.moveParentButton = new JButton(I18n.tr((String)"Move to upper group", (Object[])new Object[0]));
        this.moveParentButton.setEnabled(false);
        this.moveParentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveFolderDialog.this.moveParent();
            }
        });
        EasyPresets pp = this.parent.getParent();
        if (pp != null) {
            this.moveParentButton.setEnabled(true);
        }
        this.moveButton = new JButton(I18n.tr((String)"Move to", (Object[])new Object[0]));
        this.moveButton.setEnabled(false);
        this.moveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveFolderDialog.this.move();
            }
        });
        JButton cancelButton = new JButton(I18n.tr((String)"Close", (Object[])new Object[0]));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveFolderDialog.this.cancel();
            }
        });
        JPanel buttonPane = new JPanel(new GridBagLayout());
        buttonPane.add((Component)this.moveParentButton, GBC.std());
        buttonPane.add((Component)this.moveButton, GBC.std());
        buttonPane.add((Component)cancelButton, GBC.eol());
        return buttonPane;
    }

    protected void moveParent() {
        EasyPresets pp = this.parent.getParent();
        if (pp != null) {
            this.entry.setParent(pp);
            pp.addElement(this.entry);
            this.parent.removeElement(this.entry);
            this.dispose();
        }
    }

    protected void move() {
        EasyPresets destGroup = (EasyPresets)this.list.getSelectedValue();
        this.entry.setParent(destGroup);
        destGroup.addElement(this.entry);
        this.parent.removeElement(this.entry);
        this.dispose();
    }

    protected void cancel() {
        this.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        PresetsEntry selected = this.list.getSelectedValue();
        if (selected == null) {
            this.moveButton.setEnabled(false);
        } else {
            this.moveButton.setEnabled(true);
        }
    }
}

