/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui.editor;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.maripo.josm.easypresets.ui.editor.PresetEditorDialog;
import org.maripo.josm.easypresets.ui.editor.TagEditor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagsPane
extends JPanel {
    private List<TagEditor> tagEditors;
    List<Line> lines;
    private PresetEditorDialog baseDialog;

    public TagsPane(List<TagEditor> tagEditors, PresetEditorDialog baseDialog) {
        super(new GridBagLayout());
        this.baseDialog = baseDialog;
        this.tagEditors = tagEditors;
        this.lines = new ArrayList<Line>();
        this.createHeader();
        for (TagEditor editor : tagEditors) {
            this.appendEditorUI(editor);
        }
        this.repaintAll();
    }

    private void createHeader() {
        this.add((Component)new JLabel(I18n.tr((String)"Use", (Object[])new Object[0])), GBC.std().insets(5, 0, 5, 0).anchor(18));
        this.add((Component)new JLabel(I18n.tr((String)"Type", (Object[])new Object[0])), GBC.std().insets(5, 0, 5, 0).anchor(18));
        this.add((Component)new JLabel(I18n.tr((String)"Key", (Object[])new Object[0])), GBC.std().insets(5, 0, 5, 0).anchor(18));
        this.add((Component)new JLabel(I18n.tr((String)"Label", (Object[])new Object[0]) + "(" + I18n.tr((String)"Optional", (Object[])new Object[0]) + ")"), GBC.std().insets(5, 0, 5, 0).anchor(18));
        this.add((Component)new JLabel(I18n.tr((String)"Value", (Object[])new Object[0])), GBC.std().insets(5, 0, 5, 0).anchor(18));
        this.add((Component)new JLabel(I18n.tr((String)"Order", (Object[])new Object[0])), GBC.eol().insets(5, 0, 5, 0).anchor(18).fill(2));
    }

    private void reorder(int index, int direction) {
        int toIndex;
        int fromIndex;
        if (direction > 0) {
            fromIndex = index;
            toIndex = index + direction;
        } else {
            fromIndex = index + direction;
            toIndex = index;
        }
        if (fromIndex < 0 || toIndex >= this.lines.size()) {
            return;
        }
        TagEditor fromEditor = this.tagEditors.get(fromIndex);
        TagEditor toEditor = this.tagEditors.get(toIndex);
        this.tagEditors.remove(toEditor);
        this.tagEditors.add(fromIndex, toEditor);
        this.lines.get(fromIndex).removeUI();
        this.lines.get(toIndex).removeUI();
        this.lines.get(fromIndex).renderEditor(toEditor);
        this.lines.get(toIndex).renderEditor(fromEditor);
        this.repaintAll();
    }

    private void repaintAll() {
        for (Line line : this.lines) {
            line.downButton.setVisible(line.index < this.lines.size() - 1);
            line.revalidateComponents();
        }
        this.repaint();
        this.baseDialog.repaint();
    }

    private void appendEditorUI(TagEditor editor) {
        Line line = new Line(editor, this.lines.size());
        this.lines.add(line);
        this.invalidate();
    }

    public void addTag() {
        TagEditor editor = TagEditor.create(this.baseDialog);
        this.tagEditors.add(editor);
        this.appendEditorUI(editor);
        this.repaintAll();
    }

    public List<TagEditor> getTagEditors() {
        return this.tagEditors;
    }

    class Line
    implements ActionListener {
        private int index;
        JButton upButton;
        JButton downButton;
        private JPanel containerInclude;
        private JPanel containerType;
        private JPanel containerKey;
        private JPanel containerLabel;
        private JPanel containerValue;

        public Line(TagEditor editor, int index) {
            this.index = index;
            this.containerInclude = new JPanel(new GridBagLayout());
            this.containerType = new JPanel(new GridBagLayout());
            this.containerKey = new JPanel(new GridBagLayout());
            this.containerLabel = new JPanel(new GridBagLayout());
            this.containerValue = new JPanel(new GridBagLayout());
            this.renderEditor(editor);
            TagsPane.this.add((Component)this.containerInclude, GBC.std().insets(0).anchor(17));
            TagsPane.this.add((Component)this.containerType, GBC.std().insets(0).anchor(17));
            TagsPane.this.add((Component)this.containerKey, GBC.std().insets(0).anchor(17));
            TagsPane.this.add((Component)this.containerLabel, GBC.std().insets(0).anchor(17));
            TagsPane.this.add((Component)this.containerValue, GBC.std().insets(0).anchor(17));
            JPanel orderButtonsPanel = new JPanel(new GridLayout(1, 2));
            this.upButton = new JButton();
            this.downButton = new JButton();
            this.upButton.setIcon(ImageProvider.get((String)"dialogs", (String)"up", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
            this.downButton.setIcon(ImageProvider.get((String)"dialogs", (String)"down", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
            this.upButton.addActionListener(this);
            this.downButton.addActionListener(this);
            orderButtonsPanel.add(this.upButton);
            orderButtonsPanel.add(this.downButton);
            if (index == 0) {
                this.upButton.setVisible(false);
            }
            TagsPane.this.add((Component)orderButtonsPanel, GBC.eol().insets(0).fill(2));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.upButton) {
                TagsPane.this.reorder(this.index, -1);
            }
            if (e.getSource() == this.downButton) {
                TagsPane.this.reorder(this.index, 1);
            }
        }

        public void removeUI() {
            this.containerInclude.remove(0);
            this.containerType.remove(0);
            this.containerLabel.remove(0);
            this.containerKey.remove(0);
            this.containerValue.remove(0);
        }

        public void renderEditor(TagEditor editor) {
            this.containerInclude.add(editor.getUiInclude(), GBC.eol().insets(0));
            this.containerType.add(editor.getUiType(), GBC.eol().insets(0));
            this.containerKey.add(editor.getUiKey(), GBC.eol().insets(0));
            this.containerLabel.add(editor.getUiLabel(), GBC.eol().insets(0));
            this.containerValue.add(editor.getUiValue(), GBC.eol().insets(0));
        }

        public void revalidateComponents() {
            this.containerInclude.revalidate();
            this.containerType.revalidate();
            this.containerLabel.revalidate();
            this.containerKey.revalidate();
            this.containerValue.revalidate();
        }
    }
}

