/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.maripo.josm.easypresets.data.EasyPresets;
import org.maripo.josm.easypresets.ui.editor.ValuesEditorDialog;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.Combo;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.MultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.Text;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TagEditor {
    String[] inputValues = new String[0];
    private static final String TYPE_FIXED = I18n.tr((String)"Fixed value", (Object[])new Object[0]);
    private static final String TYPE_TEXTBOX = I18n.tr((String)"Textbox", (Object[])new Object[0]);
    private static final String TYPE_SELECT = I18n.tr((String)"Selection", (Object[])new Object[0]);
    private static final String TYPE_MULTISELECT;
    private static final String TYPE_CHECKBOX;
    private static final String TYPE_DEFAULT;
    private static final String[] TYPE_OPTIONS;
    private JCheckBox uiInclude;
    private JComboBox<String> uiType;
    private KeyField keyField;
    private JPanel valuePanel;
    Map<String, ValueField> fields;
    private ExtendedDialog baseDialog;
    private String prevSelectedType = null;
    private JPanel parentPane;
    JTextField uiLabel = new JTextField(8);
    JLabel uiLabelNA = new JLabel("(" + I18n.tr((String)"Unavailable", (Object[])new Object[0]) + ")");
    JPanel uiLabelWrapper;

    public TagEditor(ExtendedDialog baseDialog) {
        this.uiLabelNA.setToolTipText(I18n.tr((String)"A field of this type doesn't have a label.", (Object[])new Object[0]));
        this.uiLabelNA.setForeground(Color.GRAY);
        this.uiLabelWrapper = new JPanel(new GridBagLayout());
        this.uiLabelWrapper.add(this.uiLabelNA);
        this.uiLabelWrapper.add((Component)this.uiLabel, GBC.std().insets(0, 0, 0, 0).grid(0, 0));
        this.baseDialog = baseDialog;
        this.uiInclude = new JCheckBox();
        this.uiInclude.setSelected(true);
        this.uiType = new JComboBox();
        this.valuePanel = new JPanel(new FlowLayout(0));
        this.fields = new HashMap<String, ValueField>();
        this.fields.put(TYPE_FIXED, new ValueFieldFixed());
        this.fields.put(TYPE_TEXTBOX, new ValueFieldTextbox());
        this.fields.put(TYPE_SELECT, new ValueFieldSelection());
        this.fields.put(TYPE_MULTISELECT, new ValueFieldMultiselect());
        this.fields.put(TYPE_CHECKBOX, new ValueFieldCheckbox());
        for (String label : TYPE_OPTIONS) {
            this.uiType.addItem(label);
            this.fields.get(label).appendUI(this.valuePanel);
        }
    }

    protected void onSelectedTypeChange() {
        String selectedType = (String)this.uiType.getSelectedItem();
        this.switchType(selectedType);
    }

    private void switchType(String selectedType) {
        for (String type : TYPE_OPTIONS) {
            boolean isSelected = type.equals(selectedType);
            ValueField field = this.fields.get(type);
            field.setVisibility(isSelected);
        }
        ValueField selectedValueField = this.getSelectedValueField();
        if (this.prevSelectedType != null) {
            this.fields.get(this.prevSelectedType).applyEditedValues();
            selectedValueField.populateDefaultValue(this.inputValues);
        }
        this.uiLabel.setVisible(selectedValueField.hasLabel());
        this.uiLabelNA.setVisible(!selectedValueField.hasLabel());
        if (this.uiLabel.getParent() != null) {
            this.uiLabel.getParent().revalidate();
        }
        this.prevSelectedType = selectedType;
        if (this.parentPane != null) {
            this.parentPane.revalidate();
        }
    }

    private ValueField getSelectedValueField() {
        return this.fields.get(this.uiType.getSelectedItem());
    }

    public static TagEditor create(ExtendedDialog baseDialog) {
        TagEditor instance = new TagEditor(baseDialog);
        instance.keyField = new KeyFieldEditable();
        instance.switchType(TYPE_DEFAULT);
        instance.initUI();
        return instance;
    }

    public static TagEditor create(ExtendedDialog baseDialog, String key, Map<String, Integer> map, EasyPresets presets) {
        TagEditor instance = new TagEditor(baseDialog);
        instance.keyField = new KeyFieldFixed(key);
        instance.switchType(TYPE_DEFAULT);
        instance.uiType.setSelectedItem(TYPE_DEFAULT);
        if (!map.isEmpty()) {
            String firstKey = map.keySet().iterator().next();
            instance.uiLabel.setText(presets.getLabelFromExistingPresets(key));
            instance.getSelectedValueField().populateDefaultValue(firstKey);
        }
        instance.initUI();
        return instance;
    }

    public static TagEditor create(ExtendedDialog baseDialog, TaggingPresetItem item) {
        String type;
        TagEditor instance = new TagEditor(baseDialog);
        if (!(item instanceof KeyedItem)) {
            return null;
        }
        KeyedItem tag = (KeyedItem)item;
        instance.uiLabel.setText(tag.text);
        if (tag instanceof Text) {
            type = TYPE_TEXTBOX;
        } else if (tag instanceof Key) {
            type = TYPE_FIXED;
        } else if (tag instanceof Combo) {
            type = TYPE_SELECT;
        } else if (tag instanceof MultiSelect) {
            type = TYPE_MULTISELECT;
        } else if (tag instanceof Check) {
            type = TYPE_CHECKBOX;
        } else {
            return null;
        }
        instance.uiType.setSelectedItem(type);
        instance.switchType(type);
        instance.getSelectedValueField().populateDefaultValue(tag.getValues().toArray(new String[0]));
        instance.keyField = new KeyFieldFixed(tag.key);
        instance.initUI();
        return instance;
    }

    private void initUI() {
        this.uiType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagEditor.this.onSelectedTypeChange();
            }
        });
    }

    public void _appendUI(JPanel pane) {
    }

    public TaggingPresetItem getTaggingPresetItem() {
        if (!this.uiInclude.isSelected() || this.keyField.getKey().isEmpty()) {
            return null;
        }
        this.getSelectedValueField().applyEditedValues();
        KeyedItem item = this.getSelectedValueField().createItem();
        item.key = this.keyField.getKey();
        if (this.getSelectedValueField().hasLabel() && !this.uiLabel.getText().isEmpty()) {
            item.text = this.uiLabel.getText();
        }
        return item;
    }

    public Component getUiInclude() {
        return this.uiInclude;
    }

    public Component getUiType() {
        return this.uiType;
    }

    public Component getUiKey() {
        return this.keyField.getUI();
    }

    public Component getUiValue() {
        return this.valuePanel;
    }

    public Component getUiLabel() {
        return this.uiLabelWrapper;
    }

    static {
        TYPE_CHECKBOX = I18n.tr((String)"Checkbox", (Object[])new Object[0]);
        TYPE_MULTISELECT = I18n.tr((String)"Multiselect", (Object[])new Object[0]);
        TYPE_DEFAULT = TYPE_FIXED;
        TYPE_OPTIONS = new String[]{TYPE_FIXED, TYPE_TEXTBOX, TYPE_SELECT, TYPE_CHECKBOX, TYPE_MULTISELECT};
    }

    static class ValueFieldCheckbox
    extends ValueField {
        @Override
        public void appendUI(JPanel pane) {
        }

        @Override
        public void setVisibility(boolean isSelected) {
        }

        @Override
        public void populateDefaultValue(String ... values) {
        }

        @Override
        public void applyEditedValues() {
        }

        @Override
        public KeyedItem createItem() {
            Check item = new Check();
            return item;
        }
    }

    class ValueFieldMultiselect
    extends ValueFieldSelection {
        ValueFieldMultiselect() {
        }

        @Override
        protected ComboMultiSelect createEmptyItem() {
            return new MultiSelect();
        }

        @Override
        protected char getDefaultDelimiter() {
            return ';';
        }
    }

    class ValueFieldSelection
    extends ValueField
    implements ActionListener,
    ValuesEditorDialog.ValuesEditorDialogListener {
        JButton button = new JButton(I18n.tr((String)"Edit options", (Object[])new Object[0]) + "...");
        JLabel label = new JLabel();
        String[] values;

        public ValueFieldSelection() {
            this.button.addActionListener(this);
        }

        @Override
        public void appendUI(JPanel pane) {
            pane.add(this.label);
            pane.add(this.button);
        }

        @Override
        public void setVisibility(boolean visible) {
            this.button.setVisible(visible);
            this.label.setVisible(visible);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ValuesEditorDialog(TagEditor.this.baseDialog, this.values).setListener(this).showDialog();
        }

        @Override
        public void populateDefaultValue(String ... values) {
            this.values = values;
            if (values.length == 1) {
                this.label.setText(values[0]);
                this.label.setToolTipText(null);
            } else {
                this.label.setText(I18n.tr((String)"{0} options", (Object[])new Object[]{values.length}));
                this.label.setToolTipText(String.join((CharSequence)", ", values));
            }
        }

        @Override
        public void applyEditedValues() {
            TagEditor.this.inputValues = this.values;
        }

        protected ComboMultiSelect createEmptyItem() {
            return new Combo();
        }

        protected char getDefaultDelimiter() {
            return ',';
        }

        @Override
        public KeyedItem createItem() {
            ComboMultiSelect item = this.createEmptyItem();
            StringBuilder valueString = new StringBuilder();
            for (String value : TagEditor.this.inputValues) {
                if (valueString.length() > 0) {
                    valueString.append(this.getDefaultDelimiter());
                }
                valueString.append(value.replace(",", "\\,"));
            }
            item.values = valueString.toString();
            return item;
        }

        @Override
        public void onInput(String[] values) {
            this.populateDefaultValue(values);
        }

        @Override
        public void onCancel() {
        }
    }

    class ValueFieldTextbox
    extends ValueField {
        JTextField textField = new JTextField(10);
        JLabel labelDefault = new JLabel("(" + I18n.tr((String)"Default", (Object[])new Object[0]) + ")");
        private static final int DEFAULT_COLUMNS = 10;

        @Override
        public void appendUI(JPanel pane) {
            pane.add(this.textField);
            pane.add(this.labelDefault);
        }

        @Override
        public void setVisibility(boolean visible) {
            this.textField.setVisible(visible);
            this.labelDefault.setVisible(visible);
        }

        @Override
        public void populateDefaultValue(String ... values) {
            if (values.length > 0) {
                this.textField.setText(values[0]);
            }
        }

        @Override
        public void applyEditedValues() {
            if (TagEditor.this.inputValues.length == 0) {
                TagEditor.this.inputValues = new String[1];
            }
            TagEditor.this.inputValues[0] = this.textField.getText();
        }

        @Override
        public KeyedItem createItem() {
            Text item = new Text();
            if (TagEditor.this.inputValues != null && TagEditor.this.inputValues.length > 0) {
                item.default_ = TagEditor.this.inputValues[0];
            }
            return item;
        }
    }

    class ValueFieldFixed
    extends ValueField {
        JTextField textField = new JTextField(10);
        private static final int DEFAULT_COLUMNS = 10;

        @Override
        public void appendUI(JPanel pane) {
            pane.add(this.textField);
        }

        @Override
        public boolean hasLabel() {
            return false;
        }

        @Override
        public void setVisibility(boolean visible) {
            this.textField.setVisible(visible);
        }

        @Override
        public void populateDefaultValue(String ... values) {
            if (values.length > 0) {
                this.textField.setText(values[0]);
            }
        }

        @Override
        public void applyEditedValues() {
            if (TagEditor.this.inputValues.length == 0) {
                TagEditor.this.inputValues = new String[1];
            }
            TagEditor.this.inputValues[0] = this.textField.getText();
        }

        @Override
        public KeyedItem createItem() {
            Key item = new Key();
            if (TagEditor.this.inputValues != null && TagEditor.this.inputValues.length > 0) {
                item.value = TagEditor.this.inputValues[0];
            }
            return item;
        }
    }

    static abstract class ValueField {
        ValueField() {
        }

        public abstract void appendUI(JPanel var1);

        public abstract void setVisibility(boolean var1);

        public abstract void populateDefaultValue(String ... var1);

        public abstract void applyEditedValues();

        public abstract KeyedItem createItem();

        public boolean hasLabel() {
            return true;
        }
    }

    static class KeyFieldEditable
    extends KeyField {
        private static final int DEFAULT_COLUMNS = 8;
        JTextField textfield = new JTextField(8);

        @Override
        public Component getUI() {
            return this.textfield;
        }

        @Override
        public String getKey() {
            return this.textfield.getText();
        }
    }

    static class KeyFieldFixed
    extends KeyField {
        JLabel label;
        private String key;

        public KeyFieldFixed(String key) {
            this.key = key;
            this.label = new JLabel(key);
        }

        @Override
        public Component getUI() {
            return this.label;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    static abstract class KeyField {
        KeyField() {
        }

        public abstract Component getUI();

        public abstract String getKey();
    }
}

