/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.maripo.josm.easypresets.data.EasyPreset;
import org.maripo.josm.easypresets.data.EasyPresets;
import org.maripo.josm.easypresets.ui.editor.IconPickerDialog;
import org.maripo.josm.easypresets.ui.editor.TagEditor;
import org.maripo.josm.easypresets.ui.editor.TagsPane;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.items.Label;
import org.openstreetmap.josm.gui.tagging.presets.items.Link;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PresetEditorDialog
extends ExtendedDialog {
    private JTextField uiPresetName;
    private JTextField uiURL;
    private JCheckBox uiIncludeName;
    private Icon icon;
    private String iconPath;
    private List<TargetType> targetTypes = new ArrayList<TargetType>();
    private String name;
    private String referenceURL;
    private EasyPreset presetToEdit;
    protected Collection<TaggingPresetType> defaultTypes;
    private int index = -1;
    private EasyPresets parentPresets;
    TagsPane tagsPane;
    JLabel errorMessageLabel;

    public PresetEditorDialog(Map<String, Map<String, Integer>> tagMap, List<TaggingPresetType> presetTypes, EasyPresets presets) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Preset Editor", (Object[])new Object[0]), new String[0]);
        this.defaultTypes = presetTypes;
        this.parentPresets = presets;
        ArrayList<TagEditor> tagEditors = new ArrayList<TagEditor>();
        for (String key : tagMap.keySet()) {
            TagEditor editor = TagEditor.create(this, key, tagMap.get(key), presets);
            tagEditors.add(editor);
        }
        this.name = "";
        this.initUI(tagEditors);
    }

    public PresetEditorDialog(EasyPreset preset, int index, EasyPresets parentPresets) {
        this(preset, null, index, parentPresets);
    }

    public PresetEditorDialog(EasyPreset preset, Map<String, Map<String, Integer>> tagMap, int index, EasyPresets parentPresets) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Preset Editor", (Object[])new Object[0]), new String[0]);
        TagEditor editor;
        this.index = index;
        this.parentPresets = parentPresets;
        this.name = preset.getLocaleName();
        this.referenceURL = this.findURL(preset);
        this.icon = preset.getIcon();
        this.iconPath = preset.iconName;
        this.presetToEdit = preset.clone();
        this.defaultTypes = preset.types;
        ArrayList<TagEditor> tagEditors = new ArrayList<TagEditor>();
        if (tagMap != null) {
            for (String key : tagMap.keySet()) {
                editor = TagEditor.create(this, key, tagMap.get(key), parentPresets);
                tagEditors.add(editor);
            }
        }
        for (TaggingPresetItem item : preset.data) {
            editor = TagEditor.create(this, item);
            if (editor == null) continue;
            tagEditors.add(editor);
        }
        this.initUI(tagEditors);
        boolean containsLabel = false;
        for (TaggingPresetItem field : preset.data) {
            if (!(field instanceof Label)) continue;
            containsLabel = true;
        }
        this.uiIncludeName.setSelected(containsLabel);
    }

    private String findURL(TaggingPreset preset) {
        if (preset.data != null) {
            for (TaggingPresetItem item : preset.data) {
                if (!(item instanceof Link)) continue;
                return ((Link)item).href;
            }
        }
        return null;
    }

    private void initUI(List<TagEditor> tagEditors) {
        this.targetTypes.add(new TargetType(TaggingPresetType.NODE));
        this.targetTypes.add(new TargetType(TaggingPresetType.WAY));
        this.targetTypes.add(new TargetType(TaggingPresetType.CLOSEDWAY));
        this.targetTypes.add(new TargetType(TaggingPresetType.RELATION));
        this.targetTypes.add(new TargetType(TaggingPresetType.MULTIPOLYGON));
        JPanel mainPane = new JPanel(new GridBagLayout());
        mainPane.add((Component)new JLabel(I18n.tr((String)"PresetEditorDialogreset Name", (Object[])new Object[0]) + ":"), GBC.std().insets(0, 0, 0, 10).anchor(17));
        this.uiPresetName = new JTextField(16);
        this.uiPresetName.setText(this.name);
        this.uiIncludeName = new JCheckBox();
        this.uiIncludeName.setSelected(true);
        JLabel label = new JLabel(I18n.tr((String)"Show the name on the dialog", (Object[])new Object[0]));
        label.setLabelFor(this.uiIncludeName);
        mainPane.add((Component)this.uiPresetName, GBC.std().insets(0, 0, 0, 10));
        mainPane.add((Component)this.uiIncludeName, GBC.std().insets(0, 0, 0, 10));
        mainPane.add((Component)label, GBC.eol().insets(0, 0, 0, 10));
        JPanel typesPane = new JPanel(new GridBagLayout());
        int index = 0;
        for (TargetType type : this.targetTypes) {
            typesPane.add(type.createCheckbox());
            typesPane.add(new JLabel(ImageProvider.get((String)type.type.getIconName())));
            GBC constraints = index % 3 == 2 ? GBC.eol() : GBC.std();
            typesPane.add((Component)new JLabel(I18n.tr((String)type.type.getName(), (Object[])new Object[0])), constraints);
            ++index;
        }
        mainPane.add((Component)new JLabel(I18n.tr((String)"Icon", (Object[])new Object[0]) + ":"), GBC.std().anchor(18));
        JPanel iconPane = new JPanel(new GridBagLayout());
        final JLabel iconLabel = new JLabel();
        final JLabel iconPathLabel = new JLabel();
        if (this.icon != null) {
            iconLabel.setIcon(this.icon);
        }
        if (this.iconPath != null && !this.iconPath.isEmpty()) {
            iconPathLabel.setText(this.iconPath);
        }
        JButton iconPickerButton = new JButton(I18n.tr((String)"Select icon", (Object[])new Object[0]) + "...");
        final PresetEditorDialog dialog = this;
        iconPickerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IconPickerDialog iconPickerDialog = new IconPickerDialog(dialog);
                iconPickerDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                iconPickerDialog.setAlwaysOnTop(true);
                iconPickerDialog.setupDialog();
                iconPickerDialog.setListener(new IconPickerDialog.IconPickerDialogListener(){

                    @Override
                    public void onSelectIcon(ImageIcon _icon, String name) {
                        PresetEditorDialog.this.icon = _icon;
                        iconLabel.setIcon(PresetEditorDialog.this.icon);
                        iconPathLabel.setText(name);
                        iconLabel.revalidate();
                        iconPathLabel.revalidate();
                        PresetEditorDialog.this.iconPath = name;
                    }

                    @Override
                    public void onCancel() {
                    }
                });
                iconPickerDialog.showDialog();
            }
        });
        iconPane.add((Component)iconLabel, GBC.std().insets(0));
        iconPane.add((Component)iconPathLabel, GBC.std().insets(0));
        iconPane.add((Component)iconPickerButton, GBC.std().insets(0));
        mainPane.add((Component)iconPane, GBC.eol());
        mainPane.add((Component)iconPane, GBC.eol().insets(0, 0, 0, 5).anchor(18));
        mainPane.add((Component)new JLabel(I18n.tr((String)"Applies to", (Object[])new Object[0]) + ":"), GBC.std().anchor(18));
        mainPane.add((Component)typesPane, GBC.eol().insets(0, 0, 0, 5).anchor(18));
        mainPane.add((Component)new JLabel(I18n.tr((String)"Reference URL", (Object[])new Object[0]) + ":"), GBC.std().anchor(18));
        this.uiURL = new JTextField();
        this.uiURL.setText(this.referenceURL);
        mainPane.add((Component)this.uiURL, GBC.eol().fill());
        mainPane.add((Component)new JLabel(I18n.tr((String)"Tags", (Object[])new Object[0]) + ":"), GBC.eol().anchor(18));
        this.tagsPane = new TagsPane(tagEditors, this);
        if (tagEditors.isEmpty()) {
            this.tagsPane.addTag();
        }
        JPanel listWrapper = new JPanel();
        listWrapper.setLayout(new GridBagLayout());
        listWrapper.add((Component)this.tagsPane, GBC.eol());
        listWrapper.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        JScrollPane scroll = new JScrollPane(listWrapper);
        scroll.setAlignmentX(0.0f);
        scroll.setAlignmentY(0.0f);
        scroll.setPreferredSize(new Dimension(640, 300));
        mainPane.add((Component)scroll, GBC.eol().fill(2).insets(0, 0, 0, 0));
        JButton addTagButton = new JButton(I18n.tr((String)"Add Tag", (Object[])new Object[0]));
        addTagButton.setIcon(ImageProvider.get((String)"dialogs", (String)"add", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        addTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetEditorDialog.this.addTag();
            }
        });
        mainPane.add((Component)addTagButton, GBC.eol().insets(0, 0, 0, 15));
        JButton saveButton = new JButton(I18n.tr((String)"Save", (Object[])new Object[0]));
        saveButton.setIcon(ImageProvider.get((String)"ok", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetEditorDialog.this.save();
            }
        });
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        cancelButton.setIcon(ImageProvider.get((String)"cancel", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetEditorDialog.this.close();
            }
        });
        this.errorMessageLabel = new JLabel("");
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setVisible(false);
        mainPane.add((Component)this.errorMessageLabel, GBC.eol().fill());
        mainPane.add((Component)saveButton, GBC.std());
        mainPane.add((Component)cancelButton, GBC.eol());
        this.setContent(mainPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PresetEditorDialog.this.toFront();
            }
        });
    }

    protected void addTag() {
        this.tagsPane.addTag();
        this.repaint();
    }

    protected void close() {
        this.dispose();
    }

    public void dispose() {
        super.dispose();
    }

    void showErrorMessage(String message) {
        if (message == null || message.isEmpty()) {
            this.errorMessageLabel.setVisible(false);
        } else {
            this.errorMessageLabel.setVisible(true);
            this.errorMessageLabel.setText(message);
        }
    }

    protected void save() {
        this.showErrorMessage("");
        List<String> errors = this.validateInput();
        if (!errors.isEmpty()) {
            this.showErrorMessage(errors.get(0));
            return;
        }
        if (this.presetToEdit != null) {
            String str = this.uiPresetName.getText().trim();
            if (str == null || str.length() < 1) {
                str = this.presetToEdit.getName();
                this.uiPresetName.setText(str);
            }
            this.presetToEdit.name = str;
            this.parentPresets.setElementAt(this.applyToPreset(this.presetToEdit), this.index);
        } else {
            this.parentPresets.addElement(this.applyToPreset(new EasyPreset()));
        }
        this.close();
    }

    private List<String> validateInput() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.uiPresetName.getText().isEmpty()) {
            errors.add(I18n.tr((String)"Preset name is empty.", (Object[])new Object[0]));
        }
        boolean hasItem = false;
        List<TagEditor> tagEditors = this.tagsPane.getTagEditors();
        for (TagEditor editor : tagEditors) {
            if (editor.getTaggingPresetItem() == null) continue;
            hasItem = true;
        }
        if (!hasItem) {
            errors.add(I18n.tr((String)"Tag list is empty.", (Object[])new Object[0]));
        }
        return errors;
    }

    private EasyPreset applyToPreset(EasyPreset src) {
        EasyPreset preset = src.clone();
        preset.name = this.uiPresetName.getText();
        preset.data.clear();
        if (this.iconPath != null) {
            preset.setIcon(this.iconPath);
        }
        if (this.uiIncludeName.isSelected()) {
            Label label = new Label();
            label.text = this.uiPresetName.getText();
            preset.data.add(label);
        }
        List<TagEditor> tagEditors = this.tagsPane.getTagEditors();
        for (TagEditor editor : tagEditors) {
            TaggingPresetItem item = editor.getTaggingPresetItem();
            if (item == null) continue;
            preset.data.add(item);
        }
        if (this.uiURL.getText() != null && !this.uiURL.getText().isEmpty()) {
            Link link = new Link();
            link.href = this.uiURL.getText();
            preset.data.add(link);
        }
        preset.setDisplayName();
        if (preset.types == null) {
            preset.types = EnumSet.noneOf(TaggingPresetType.class);
        }
        preset.types = this.getSelectedTypes();
        return preset;
    }

    private Set<TaggingPresetType> getSelectedTypes() {
        EnumSet<TaggingPresetType> types = EnumSet.noneOf(TaggingPresetType.class);
        for (TargetType type : this.targetTypes) {
            if (!type.isChecked()) continue;
            types.add(type.type);
        }
        return types;
    }

    private class TargetType {
        private TaggingPresetType type;
        private boolean checked;
        private JCheckBox checkbox;

        public TargetType(TaggingPresetType type) {
            boolean checkedDefault;
            this.type = type;
            this.checked = checkedDefault = PresetEditorDialog.this.defaultTypes != null && PresetEditorDialog.this.defaultTypes.contains(type);
        }

        public JCheckBox createCheckbox() {
            this.checkbox = new JCheckBox();
            this.checkbox.setSelected(this.checked);
            return this.checkbox;
        }

        public boolean isChecked() {
            return this.checkbox.isSelected();
        }
    }
}

