/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui.editor;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class IconPickerDialog
extends ExtendedDialog
implements MouseListener {
    IconPickerDialogListener listener;
    JPanel mainPane;
    List<Icon> icons = new ArrayList<Icon>();

    public IconPickerDialog(ExtendedDialog baseDialog) {
        super((Component)baseDialog, I18n.tr((String)"Icon", (Object[])new Object[0]), new String[0]);
        this.mainPane = new JPanel(new GridBagLayout());
        JPanel iconsPane = new JPanel(new GridBagLayout());
        Collection existingPresets = TaggingPresets.getTaggingPresets();
        ArrayList<String> images = new ArrayList<String>();
        for (TaggingPreset preset : existingPresets) {
            if (preset.iconName == null || images.contains(preset.iconName)) continue;
            images.add(preset.iconName);
            this.icons.add(new Icon(preset.getIcon(), preset.iconName));
        }
        int IMAGES_PER_LINE = 32;
        for (int i = 0; i < this.icons.size(); ++i) {
            Icon icon = this.icons.get(i);
            JLabel label = new JLabel(icon.icon);
            label.setToolTipText(icon.name);
            label.addMouseListener(this);
            icon.setConponent(label);
            iconsPane.add((Component)label, i % IMAGES_PER_LINE == IMAGES_PER_LINE - 1 ? GBC.eol() : GBC.std());
        }
        this.mainPane.add((Component)iconsPane, GBC.eop());
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IconPickerDialog.this.listener != null) {
                    IconPickerDialog.this.listener.onCancel();
                }
                IconPickerDialog.this.dispose();
            }
        });
        this.mainPane.add((Component)cancelButton, GBC.eol());
        this.setContent(this.mainPane);
    }

    public void setListener(IconPickerDialogListener listener) {
        this.listener = listener;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof JLabel) {
            JLabel label = (JLabel)o;
            this.mainPane.add(new JLabel(label.getToolTipText()));
            if (this.listener != null) {
                for (Icon icon : this.icons) {
                    if (label != icon.component) continue;
                    this.listener.onSelectIcon(icon.icon, icon.name);
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private static class Icon {
        private ImageIcon icon;
        private String name;
        private JLabel component;

        public Icon(ImageIcon icon, String iconName) {
            this.icon = icon;
            this.name = iconName;
        }

        public void setConponent(JLabel label) {
            this.component = label;
        }
    }

    public static interface IconPickerDialogListener {
        public void onSelectIcon(ImageIcon var1, String var2);

        public void onCancel();
    }
}

