/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.maripo.josm.easypresets.data.EasyPreset;
import org.maripo.josm.easypresets.data.EasyPresets;
import org.maripo.josm.easypresets.data.EasySeparator;
import org.maripo.josm.easypresets.data.PresetsEntry;
import org.maripo.josm.easypresets.ui.ExportDialog;
import org.maripo.josm.easypresets.ui.PresetRenderer;
import org.maripo.josm.easypresets.ui.editor.PresetEditorDialog;
import org.maripo.josm.easypresets.ui.move.MoveFolderDialog;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ManagePresetsDialog
extends ExtendedDialog
implements ListSelectionListener {
    private JTextField uiGroupName;
    private JButton folderButton;
    private JButton organizeButton;
    private JButton createButton;
    private JButton separatorButton;
    private JButton editButton;
    private JButton copyButton;
    private JButton deleteButton;
    private JButton reorderUpButton;
    private JButton reorderDownButton;
    private EasyPresets parent;
    private EasyPresets presets;
    int index;
    JList<PresetsEntry> list;
    Map<String, Map<String, Integer>> tagMap;
    List<TaggingPresetType> targetTypes;

    public ManagePresetsDialog(EasyPresets presets) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Manage Custom Presets", (Object[])new Object[0]), new String[0]);
        this.targetTypes = new ArrayList<TaggingPresetType>();
        this.presets = presets;
        this.tagMap = new TreeMap<String, Map<String, Integer>>();
        this.parent = null;
        this.index = 0;
        this.initUI();
    }

    public ManagePresetsDialog(Map<String, Map<String, Integer>> tagMap, List<TaggingPresetType> presetTypes, EasyPresets presets, EasyPresets parent, int index) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Manage Custom Presets", (Object[])new Object[0]), new String[0]);
        this.tagMap = tagMap == null ? new TreeMap() : tagMap;
        this.targetTypes = presetTypes == null ? new ArrayList() : presetTypes;
        this.presets = presets;
        this.parent = parent;
        this.index = index;
        this.initUI();
    }

    private void initUI() {
        this.list = new JList<PresetsEntry>(this.presets);
        this.list.setCellRenderer(new PresetRenderer());
        JPanel mainPane = new JPanel(new GridBagLayout());
        JButton exportButton = new JButton(I18n.tr((String)"Export", (Object[])new Object[0]));
        exportButton.setToolTipText(I18n.tr((String)"Export custom presets as a local XML file", (Object[])new Object[0]));
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.export();
            }
        });
        mainPane.add((Component)exportButton, GBC.eol().anchor(13));
        JLabel label = new JLabel(I18n.tr((String)"Preset Group Name", (Object[])new Object[0]));
        this.uiGroupName = new JTextField(16);
        this.uiGroupName.setText(this.presets.getLocaleName());
        this.uiGroupName.setEditable(this.parent != null);
        mainPane.add((Component)label, GBC.std().insets(0, 0, 0, 10));
        mainPane.add((Component)this.uiGroupName, GBC.eol().insets(0, 0, 0, 10));
        JPanel listPane = new JPanel(new GridBagLayout());
        JPanel buttons = new JPanel(new GridBagLayout());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ManagePresetsDialog.this.edit();
                }
            }
        });
        JScrollPane listScroll = new JScrollPane(this.list);
        listScroll.setPreferredSize(new Dimension(320, 420));
        listPane.add((Component)listScroll, GBC.std());
        this.reorderUpButton = new JButton();
        this.reorderUpButton.setIcon(ImageProvider.get((String)"dialogs", (String)"up", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.reorderUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.reorderUp();
            }
        });
        this.reorderDownButton = new JButton();
        this.reorderDownButton.setIcon(ImageProvider.get((String)"dialogs", (String)"down", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.reorderDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.reorderDown();
            }
        });
        this.reorderUpButton.setEnabled(false);
        this.reorderDownButton.setEnabled(false);
        this.reorderUpButton.setToolTipText(I18n.tr((String)"Move up", (Object[])new Object[0]));
        this.reorderDownButton.setToolTipText(I18n.tr((String)"Move down", (Object[])new Object[0]));
        this.folderButton = new JButton();
        this.folderButton.setToolTipText(I18n.tr((String)"Create a group", (Object[])new Object[0]));
        ImageProvider img = new ImageProvider("folder_create");
        img.setSize(ImageProvider.ImageSizes.LARGEICON);
        this.folderButton.setIcon(img.get());
        this.folderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.addFolder();
            }
        });
        this.folderButton.setEnabled(true);
        this.organizeButton = new JButton();
        this.organizeButton.setToolTipText(I18n.tr((String)"Organize", (Object[])new Object[0]));
        this.organizeButton.setIcon(ImageProvider.get((String)"folder_move", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.organizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ManagePresetsDialog.this.organize();
                }
                catch (CloneNotSupportedException e1) {
                    Logging.error((Throwable)e1);
                }
            }
        });
        this.organizeButton.setEnabled(false);
        this.createButton = new JButton();
        this.createButton.setToolTipText(I18n.tr((String)"Create a preset", (Object[])new Object[0]));
        this.createButton.setIcon(ImageProvider.get((String)"easypresets_add", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.create();
            }
        });
        this.createButton.setEnabled(true);
        this.separatorButton = new JButton();
        this.separatorButton.setToolTipText(I18n.tr((String)"Create a separator", (Object[])new Object[0]));
        this.separatorButton.setIcon(ImageProvider.get((String)"preferences", (String)"separator", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.separatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.separator();
            }
        });
        this.separatorButton.setEnabled(true);
        this.editButton = new JButton();
        this.editButton.setToolTipText(I18n.tr((String)"Edit", (Object[])new Object[0]));
        this.editButton.setIcon(ImageProvider.get((String)"dialogs", (String)"edit", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.edit();
            }
        });
        this.editButton.setEnabled(false);
        this.copyButton = new JButton();
        this.copyButton.setToolTipText(I18n.tr((String)"Copy", (Object[])new Object[0]));
        this.copyButton.setIcon(ImageProvider.get((String)"copy", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.copy();
            }
        });
        this.copyButton.setEnabled(false);
        this.deleteButton = new JButton();
        this.deleteButton.setToolTipText(I18n.tr((String)"Delete", (Object[])new Object[0]));
        this.deleteButton.setIcon(ImageProvider.get((String)"dialogs", (String)"delete", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.LARGEICON));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ManagePresetsDialog.this.confirmDelete()) {
                    ManagePresetsDialog.this.delete();
                }
            }
        });
        this.deleteButton.setEnabled(false);
        buttons.add((Component)this.reorderUpButton, GBC.eol());
        buttons.add((Component)this.reorderDownButton, GBC.eol());
        buttons.add((Component)this.organizeButton, GBC.eol());
        buttons.add((Component)this.folderButton, GBC.eol());
        buttons.add((Component)this.createButton, GBC.eol());
        buttons.add((Component)this.separatorButton, GBC.eol());
        buttons.add((Component)this.editButton, GBC.eol());
        buttons.add((Component)this.copyButton, GBC.eol());
        buttons.add((Component)this.deleteButton, GBC.eol());
        listPane.add((Component)buttons, GBC.eol());
        mainPane.add((Component)listPane, GBC.eol().fill());
        JButton cancelButton = new JButton(I18n.tr((String)"Close", (Object[])new Object[0]));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagePresetsDialog.this.close();
            }
        });
        mainPane.add((Component)cancelButton, GBC.eol());
        this.setContent(mainPane);
    }

    private void export() {
        new ExportDialog(this.presets).showDialog();
    }

    protected void addFolder() {
        int i = this.list.isSelectionEmpty() ? this.presets.getSize() : this.list.getSelectedIndex();
        EasyPresets folder = new EasyPresets(this.presets);
        folder.setName(I18n.tr((String)"NewGroup", (Object[])new Object[0]));
        this.presets.insertElementAt(folder, i);
        ManagePresetsDialog dialog = new ManagePresetsDialog(this.tagMap, this.targetTypes, folder, this.presets, i);
        dialog.showDialog();
    }

    protected void organize() throws CloneNotSupportedException {
        if (!this.list.isSelectionEmpty()) {
            PresetsEntry preset = this.getSelectedPreset();
            new MoveFolderDialog(preset).showDialog();
        }
    }

    protected void create() {
        int i = this.list.isSelectionEmpty() ? this.presets.getSize() : this.list.getSelectedIndex();
        EasyPreset preset = new EasyPreset();
        preset.types = EnumSet.noneOf(TaggingPresetType.class);
        for (TaggingPresetType type : this.targetTypes) {
            preset.types.add(type);
        }
        this.presets.insertElementAt(preset, i);
        PresetEditorDialog dialog = new PresetEditorDialog(preset, this.tagMap, i, this.presets);
        dialog.showDialog();
    }

    protected void separator() {
        int i = this.list.isSelectionEmpty() ? this.presets.getSize() : this.list.getSelectedIndex();
        EasySeparator separator = new EasySeparator(this.parent);
        this.presets.insertElementAt(separator, i);
    }

    protected void edit() {
        if (!this.list.isSelectionEmpty()) {
            int i = this.list.getSelectedIndex();
            PresetsEntry preset = this.getSelectedPreset();
            if (preset instanceof EasyPresets) {
                ManagePresetsDialog dialog = new ManagePresetsDialog(this.tagMap, this.targetTypes, (EasyPresets)preset, this.presets, i);
                dialog.showDialog();
            } else if (preset instanceof EasyPreset) {
                PresetEditorDialog dialog = new PresetEditorDialog((EasyPreset)preset, i, this.presets);
                dialog.showDialog();
            }
        }
    }

    private boolean copy() {
        if (!this.list.isSelectionEmpty()) {
            int index = this.list.getSelectedIndex();
            PresetsEntry copiedPreset = this.getSelectedPreset().copy();
            this.presets.insertElementAt(copiedPreset, index);
            return true;
        }
        return false;
    }

    private boolean confirmDelete() {
        ExtendedDialog dialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Delete", (Object[])new Object[0]), new String[]{I18n.tr((String)"Delete", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        dialog.setContent(I18n.tr((String)"Are you sure you want to delete \"{0}\"?", (Object[])new Object[]{this.getSelectedPreset().getName()}));
        dialog.setButtonIcons(new String[]{"ok", "cancel"});
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setAlwaysOnTop(true);
        dialog.setupDialog();
        dialog.setVisible(true);
        SwingUtilities.invokeLater(() -> dialog.toFront());
        return dialog.getValue() == 1;
    }

    private void delete() {
        if (!this.list.isSelectionEmpty()) {
            this.presets.removeElement(this.getSelectedPreset());
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void close() {
        String str = this.uiGroupName.getText().trim();
        this.presets.setName(str);
        if (this.presets.isRoot()) {
            this.presets.saveTo();
            this.presets.reloadAllPresets();
        } else {
            this.parent.setElementAt(this.presets, this.index);
        }
        this.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (this.list.isSelectionEmpty()) {
            this.reorderUpButton.setEnabled(false);
            this.reorderDownButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.organizeButton.setEnabled(false);
            return;
        }
        PresetsEntry obj = this.getSelectedPreset();
        if (obj instanceof EasySeparator) {
            this.editButton.setEnabled(false);
            this.organizeButton.setEnabled(false);
            this.copyButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.organizeButton.setEnabled(true);
            this.copyButton.setEnabled(true);
        }
        int index = this.list.getSelectedIndex();
        this.reorderDownButton.setEnabled(index < this.presets.getSize() - 1);
        this.reorderUpButton.setEnabled(index > 0);
        this.deleteButton.setEnabled(true);
    }

    PresetsEntry getSelectedPreset() {
        if (!this.list.isSelectionEmpty()) {
            int i = this.list.getSelectedIndex();
            return (PresetsEntry)this.presets.elementAt(i);
        }
        return null;
    }

    private void reorderUp() {
        if (this.list.isSelectionEmpty()) {
            return;
        }
        int i = this.list.getSelectedIndex();
        this.presets.moveUp(i);
        this.list.setSelectedIndex(i - 1);
    }

    private void reorderDown() {
        if (this.list.isSelectionEmpty()) {
            return;
        }
        int i = this.list.getSelectedIndex();
        this.presets.moveDown(i);
        this.list.setSelectedIndex(i + 1);
    }
}

