/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ListTransferHandler
extends TransferHandler {
    private int[] indices = null;
    private int addIndex = -1;
    private int addCount = 0;

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        System.out.println("canImport");
        return info.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        System.out.println("createTransferable");
        return new StringSelection(this.exportString(c));
    }

    @Override
    public int getSourceActions(JComponent c) {
        System.out.println("getSourceActions");
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        String data;
        System.out.println("importData");
        if (!info.isDrop()) {
            return false;
        }
        JList list = (JList)info.getComponent();
        DefaultListModel listModel = (DefaultListModel)list.getModel();
        JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
        int index = dl.getIndex();
        boolean insert = dl.isInsert();
        Transferable t = info.getTransferable();
        try {
            data = (String)t.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            return false;
        }
        if (insert) {
            listModel.add(index, data);
        } else {
            listModel.set(index, data);
        }
        return true;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        System.out.println("exportDone");
        this.cleanup(c, action == 2);
    }

    protected String exportString(JComponent c) {
        System.out.println("exportString");
        JList list = (JList)c;
        this.indices = list.getSelectedIndices();
        Object[] values = list.getSelectedValues();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            Object val = values[i];
            buff.append(val == null ? "" : val.toString());
            if (i == values.length - 1) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    protected void importString(JComponent c, String str) {
        System.out.println("importString");
        JList target = (JList)c;
        DefaultListModel listModel = (DefaultListModel)target.getModel();
        int index = target.getSelectedIndex();
        if (this.indices != null && index >= this.indices[0] - 1 && index <= this.indices[this.indices.length - 1]) {
            this.indices = null;
            return;
        }
        int max = listModel.getSize();
        if (index < 0) {
            index = max;
        } else if (++index > max) {
            index = max;
        }
        this.addIndex = index;
        String[] values = str.split("\n");
        this.addCount = values.length;
        for (int i = 0; i < values.length; ++i) {
            listModel.add(index++, values[i]);
        }
    }

    protected void cleanup(JComponent c, boolean remove) {
        System.out.println("cleanup");
        if (remove && this.indices != null) {
            int i;
            JList source = (JList)c;
            DefaultListModel model = (DefaultListModel)source.getModel();
            if (this.addCount > 0) {
                for (i = 0; i < this.indices.length; ++i) {
                    if (this.indices[i] <= this.addIndex) continue;
                    int n = i;
                    this.indices[n] = this.indices[n] + this.addCount;
                }
            }
            for (i = this.indices.length - 1; i >= 0; --i) {
                model.remove(this.indices[i]);
            }
        }
        this.indices = null;
        this.addCount = 0;
        this.addIndex = -1;
    }
}

