/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.maripo.josm.easypresets.data.EasyPresets;
import org.maripo.josm.easypresets.data.PresetsEntry;
import org.maripo.josm.easypresets.ui.ParameterPanelName;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ExportDialog
extends ExtendedDialog {
    private static final long serialVersionUID = -1147760276640641360L;
    EasyPresets presets;
    JLabel alertLabel;
    List<PresetWrapper> wrappers = new ArrayList<PresetWrapper>();
    ParameterPanelName presetsNamePane = new ParameterPanelName(I18n.tr((String)"Presets name", (Object[])new Object[0]), "", "Custom Presets");

    public ExportDialog(EasyPresets presets) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Export", (Object[])new Object[0]), new String[0]);
        this.presets = presets;
        this.initUI();
    }

    private void initUI() {
        JPanel headerPane = this.getHeaderPane();
        JPanel mainPane = this.getMainPane();
        JPanel buttonPane = this.getButtonPanel();
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BoxLayout(basePanel, 1));
        basePanel.add(headerPane);
        basePanel.add(mainPane);
        basePanel.add(buttonPane);
        this.setContent(basePanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportDialog.this.toFront();
            }
        });
    }

    private JPanel getHeaderPane() {
        this.presetsNamePane.setPreferredSize(new Dimension(320, 30));
        String rootName = this.presets.getLocaleName();
        if (!rootName.equals("Custom Presets")) {
            this.presetsNamePane.setText(rootName);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.presetsNamePane);
        return panel;
    }

    private JPanel getMainPane() {
        JPanel listPane = new JPanel(new GridBagLayout());
        JPanel list = new JPanel(new GridBagLayout());
        list.setBackground(Color.WHITE);
        PresetsEntry[] array = this.presets.toArray();
        for (int i = 0; i < array.length; ++i) {
            PresetWrapper wrapper = new PresetWrapper(array[i]);
            list.add(wrapper.getCheckbox());
            list.add(wrapper.getLabel(), GBC.eol().fill());
            this.wrappers.add(wrapper);
        }
        JScrollPane listScroll = new JScrollPane(list);
        listScroll.setPreferredSize(new Dimension(320, 420));
        listPane.add((Component)listScroll, GBC.std());
        this.alertLabel = new JLabel(" ");
        this.alertLabel.setForeground(Color.RED);
        JButton selectAllButton = new JButton(I18n.tr((String)"Check all", (Object[])new Object[0]));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.selectAll(true);
            }
        });
        JButton deselectAllButton = new JButton(I18n.tr((String)"Uncheck all", (Object[])new Object[0]));
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.selectAll(false);
            }
        });
        JPanel mainPane = new JPanel(new GridBagLayout());
        mainPane.add((Component)new JLabel(I18n.tr((String)"Please check presets you want to export.", (Object[])new Object[0])), GBC.eol().fill());
        mainPane.add((Component)listPane, GBC.eol().fill());
        mainPane.add((Component)this.alertLabel, GBC.eol().fill());
        mainPane.add((Component)selectAllButton, GBC.std());
        mainPane.add((Component)deselectAllButton, GBC.eol());
        return mainPane;
    }

    private JPanel getButtonPanel() {
        JButton exportButton = new JButton(I18n.tr((String)"Export", (Object[])new Object[0]));
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.exportSelected();
            }
        });
        JButton cancelButton = new JButton(I18n.tr((String)"Close", (Object[])new Object[0]));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.cancel();
            }
        });
        JPanel buttonPane = new JPanel(new GridBagLayout());
        buttonPane.add((Component)exportButton, GBC.std());
        buttonPane.add((Component)cancelButton, GBC.eol());
        return buttonPane;
    }

    protected void selectAll(boolean selected) {
        for (PresetWrapper wrapper : this.wrappers) {
            wrapper.checkbox.setSelected(selected);
        }
    }

    private void exportSelected() {
        ArrayList<PresetsEntry> selectedPresets = new ArrayList<PresetsEntry>();
        for (PresetWrapper presetWrapper : this.wrappers) {
            if (!presetWrapper.getCheckbox().isSelected()) continue;
            selectedPresets.add(presetWrapper.preset);
        }
        this.alertLabel.setText(" ");
        if (!this.presetsNamePane.isEnabled()) {
            this.alertLabel.setText(I18n.tr((String)"Illegal presets name.", (Object[])new Object[0]));
            return;
        }
        if (selectedPresets.isEmpty()) {
            this.alertLabel.setText(I18n.tr((String)"No presets are selected.", (Object[])new Object[0]));
            return;
        }
        EasyPresets root = new EasyPresets();
        root.setName(this.presetsNamePane.getText());
        for (PresetsEntry preset : selectedPresets) {
            root.addElement(preset);
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18n.tr((String)"Save Presets", (Object[])new Object[0]));
        jFileChooser.setFileFilter(new FileNameExtensionFilter("XML File", "xml"));
        int returnVal = jFileChooser.showSaveDialog((Component)((Object)this));
        if (returnVal == 0) {
            root.saveTo(jFileChooser.getSelectedFile());
        }
    }

    protected void cancel() {
        this.dispose();
    }

    static class PresetWrapper {
        JCheckBox checkbox;
        JLabel label;
        PresetsEntry preset;

        public PresetWrapper(PresetsEntry preset) {
            this.preset = preset;
            this.checkbox = new JCheckBox();
            this.label = new JLabel();
            this.label.setIcon(preset.getIcon());
            this.label.setText(preset.getLocaleName());
        }

        public JCheckBox getCheckbox() {
            return this.checkbox;
        }

        public Component getLabel() {
            return this.label;
        }
    }
}

