/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.maripo.josm.easypresets.data.EasyPresets;
import org.maripo.josm.easypresets.ui.editor.PresetEditorDialog;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CreatePresetAction
extends JosmAction {
    EasyPresets presets;

    protected CreatePresetAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        super(name, iconName, tooltip, shortcut, registerInToolbar, null, true);
    }

    public CreatePresetAction(EasyPresets root) {
        this(I18n.tr((String)"Create Preset", (Object[])new Object[0]), "easypresets_add.png", I18n.tr((String)"Create or edit your custom preset based on tags from the current selection", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:easy_presets_create", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Create Preset", (Object[])new Object[0])}), (int)114, (int)5010), true);
        this.presets = root;
    }

    public void actionPerformed(ActionEvent e) {
        OsmDataLayer layer = this.getLayerManager().getEditLayer();
        if (layer == null || layer.data == null) {
            this.showAlertDialog(I18n.tr((String)"Layer is null", (Object[])new Object[0]));
            return;
        }
        Collection selected = layer.data.getSelected();
        if (selected == null || selected.isEmpty()) {
            this.showAlertDialog(I18n.tr((String)"Selection is empty. EasyPresets creates new presets based on selected nodes or ways.", (Object[])new Object[0]));
            return;
        }
        Map<String, Map<String, Integer>> tagMap = this.findTagsFromSelection(selected);
        List<TaggingPresetType> targetTypes = this.findTypesFromSelection(selected);
        PresetEditorDialog dialog = new PresetEditorDialog(tagMap, targetTypes, this.presets);
        dialog.showDialog();
    }

    protected List<TaggingPresetType> findTypesFromSelection(Collection<OsmPrimitive> selected) {
        ArrayList<TaggingPresetType> types = new ArrayList<TaggingPresetType>();
        for (OsmPrimitive primitive : selected) {
            TaggingPresetType type = TaggingPresetType.forPrimitiveType((OsmPrimitiveType)primitive.getDisplayType());
            if (types.contains(type)) continue;
            types.add(type);
        }
        return types;
    }

    protected Map<String, Map<String, Integer>> findTagsFromSelection(Collection<OsmPrimitive> selected) {
        TreeMap<String, Map<String, Integer>> allTags = new TreeMap<String, Map<String, Integer>>();
        for (OsmPrimitive primitive : selected) {
            Map tags = primitive.getInterestingTags();
            if (tags == null) continue;
            for (String key : tags.keySet()) {
                Object valueObj = tags.get(key);
                if (valueObj instanceof String) {
                    this.incrementKeyValueCount(allTags, key, (String)valueObj);
                    continue;
                }
                List values = (List)tags.get(key);
                for (String value : values) {
                    this.incrementKeyValueCount(allTags, key, value);
                }
            }
        }
        return allTags;
    }

    private void incrementKeyValueCount(Map<String, Map<String, Integer>> allTags, String key, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!allTags.containsKey(key)) {
            allTags.put(key, new HashMap());
            Map<String, Integer> valueCountMap = allTags.get(key);
            int count = valueCountMap.containsKey(value) ? valueCountMap.get(value) : 0;
            valueCountMap.put(value, count + 1);
        }
    }

    private void showAlertDialog(String string) {
        ExtendedDialog dialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), "EasyPresets", new String[]{"OK"}).setContent(string);
        dialog.showDialog();
    }
}

