/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.ui.editor;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValuesEditorDialog
extends ExtendedDialog {
    private static final int DEFAULT_COLUMNS = 20;
    private static final int DEFAULT_ROWS = 8;
    ValuesEditorDialogListener listener;
    JTextArea textarea;

    public ValuesEditorDialog setListener(ValuesEditorDialogListener listener) {
        this.listener = listener;
        return this;
    }

    public ValuesEditorDialog(ExtendedDialog baseDialog, String[] values) {
        super((Component)baseDialog, I18n.tr((String)"Options", (Object[])new Object[0]), new String[0]);
        this.setAlwaysOnTop(true);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.textarea = new JTextArea();
        if (values != null) {
            this.textarea.setText(String.join((CharSequence)"\n", values));
        }
        this.textarea.setColumns(20);
        this.textarea.setRows(8);
        mainPanel.add((Component)this.textarea, GBC.eol().fill());
        mainPanel.add((Component)new JLabel(I18n.tr((String)"Enter one option per line.", (Object[])new Object[0])), GBC.eol());
        JButton okButton = new JButton(I18n.tr((String)"OK", (Object[])new Object[0]));
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuesEditorDialog.this.ok();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuesEditorDialog.this.cancel();
            }
        });
        mainPanel.add(okButton);
        mainPanel.add(cancelButton);
        this.setContent(mainPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ValuesEditorDialog.this.toFront();
            }
        });
    }

    private void ok() {
        if (this.listener != null) {
            ArrayList<String> validValues = new ArrayList<String>();
            for (String line : this.textarea.getText().split("\n")) {
                if (line.isEmpty()) continue;
                validValues.add(line);
            }
            this.listener.onInput(validValues.toArray(new String[0]));
        }
        this.dispose();
    }

    private void cancel() {
        if (this.listener != null) {
            this.listener.onCancel();
        }
        this.dispose();
    }

    static interface ValuesEditorDialogListener {
        public void onInput(String[] var1);

        public void onCancel();
    }
}

