/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.maripo.josm.easypresets.data.EasyPreset;
import org.maripo.josm.easypresets.data.EasySeparator;
import org.maripo.josm.easypresets.data.GroupStack;
import org.maripo.josm.easypresets.data.PresetsEntry;
import org.maripo.josm.easypresets.ui.GroupPresetMenu;
import org.openstreetmap.josm.data.preferences.sources.PresetPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Text;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EasyPresets
extends DefaultListModel<PresetsEntry>
implements PropertyChangeListener,
PresetsEntry,
Cloneable {
    private static final String FILE_NAME = "EasyPresets.xml";
    private static final String[] PRESET_FORMAT_URLS = new String[]{"https://josm.openstreetmap.de/wiki/TaggingPresets", "https://wiki.openstreetmap.org/wiki/Customising_JOSM_Presets"};
    public static final String PLUGIN_HELP_URL = "https://github.com/maripo/JOSM_easypresets/blob/master/README.md";
    private String name = "";
    EasyPresets parent = null;
    private EasyPresetsListener listener = null;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public String getXMLPath() {
        return Config.getDirs().getUserDataDirectory(true) + "/" + FILE_NAME;
    }

    public EasyPresets() {
        this(null);
    }

    public EasyPresets(EasyPresets parent) {
        this.parent = parent;
        this.addToSourceEntries();
    }

    private void addToSourceEntries() {
        String xmlPath = this.getXMLPath();
        SourceEntry customPresetsEntry = new SourceEntry(SourceType.TAGGING_PRESET, xmlPath, "EasyPresets", "EasyPresets", true);
        List entries = PresetPrefHelper.INSTANCE.get();
        for (SourceEntry entry : entries) {
            if (!xmlPath.equals(entry.url)) continue;
            return;
        }
        entries.add(customPresetsEntry);
        PresetPrefHelper.INSTANCE.put((Collection)entries);
        this.reloadAllPresets();
    }

    public void setListener(EasyPresetsListener listener) {
        this.listener = listener;
    }

    public void reloadAllPresets() {
        TaggingPresets.destroy();
        TaggingPresets.initialize();
        if (this.listener != null) {
            this.listener.onReload();
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public List<PresetsEntry> getEntry() {
        ArrayList<PresetsEntry> list = new ArrayList<PresetsEntry>();
        for (int i = 0; i < this.getSize(); ++i) {
            PresetsEntry e = (PresetsEntry)this.getElementAt(i);
            list.add(e);
        }
        return list;
    }

    public JMenu getMenu() {
        JMenu menu = new JMenu(this.name);
        return EasyPresets.getMenu(menu, this.getEntry(), this.getLocaleName());
    }

    public static JMenu getMenu(JMenu menu, List<PresetsEntry> lentry, String name) {
        for (PresetsEntry entry : lentry) {
            if (entry instanceof TaggingPresetSeparator) {
                menu.addSeparator();
                continue;
            }
            if (entry instanceof TaggingPreset) {
                JMenuItem mi = new JMenuItem((Action)((TaggingPreset)entry));
                mi.setText(((TaggingPreset)entry).getName());
                mi.setEnabled(true);
                menu.add(mi);
                continue;
            }
            if (!(entry instanceof EasyPresets)) continue;
            menu.add(((EasyPresets)entry).getMenu());
        }
        return menu;
    }

    public PresetsEntry[] toArray() {
        List<PresetsEntry> list = this.getEntry();
        return list.toArray(new PresetsEntry[list.size()]);
    }

    public void load() {
        File file = new File(this.getXMLPath());
        this.load(file);
    }

    void load(File file) {
        if (file.exists() && file.canRead()) {
            try (UTFInputStreamReader reader = UTFInputStreamReader.create((InputStream)new FileInputStream(file));){
                Collection readResult = TaggingPresetReader.readAll((Reader)reader, (boolean)true);
                if (readResult != null) {
                    GroupStack stack = new GroupStack(this);
                    for (TaggingPreset preset : readResult) {
                        EasyPresets pp;
                        String path;
                        String raw = preset.getRawName();
                        String locale = preset.getLocaleName();
                        if (locale == null) {
                            locale = "null";
                        }
                        if (!(path = raw.substring(0, raw.length() - locale.length())).startsWith(this.name)) {
                            path = this.name + "/" + path;
                        }
                        if ((pp = stack.pop(path)) == null) {
                            pp = this;
                        }
                        if (preset instanceof TaggingPresetMenu) {
                            if (locale.contentEquals(this.name)) continue;
                            EasyPresets group = new EasyPresets(pp);
                            group.setName(locale);
                            stack.push(group);
                            pp.addElement(group);
                            continue;
                        }
                        if (preset instanceof TaggingPresetSeparator) {
                            EasySeparator tag = new EasySeparator(pp);
                            pp.addElement(tag);
                            continue;
                        }
                        if (!(preset instanceof TaggingPreset)) continue;
                        EasyPreset tags = new EasyPreset(preset, pp);
                        pp.addElement(tags);
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logging.debug((String)("File not found: " + file.getAbsolutePath()));
                return;
            }
            catch (XmlParsingException e) {
                Logging.info((String)e.toString());
            }
            catch (IOException | SAXException e) {
                Logging.warn((Throwable)e);
            }
        }
    }

    @Override
    public void addElement(PresetsEntry preset) {
        super.addElement(preset);
    }

    @Override
    public void setElementAt(PresetsEntry element, int index) {
        super.setElementAt(element, index);
    }

    public void saveTo() {
        File file = new File(this.getXMLPath());
        this.saveTo(file);
    }

    public void saveTo(File file) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element presetsElement = this.getPresetsElement(doc);
            presetsElement.appendChild(doc.createComment(this.getComment()));
            doc.appendChild(presetsElement);
            Element groupElement = this.getGroupElement(doc);
            if (groupElement.hasChildNodes()) {
                presetsElement.appendChild(groupElement);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            Logging.warn((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            Logging.warn((Throwable)e);
        }
        catch (TransformerException e) {
            Logging.warn((Throwable)e);
        }
    }

    Element getPresetsElement(Document doc) {
        Element presetsElement = doc.createElement("presets");
        presetsElement.setAttribute("xmlns", "http://josm.openstreetmap.de/tagging-preset-1.0");
        presetsElement.setAttribute("author", "");
        presetsElement.setAttribute("version", "");
        presetsElement.setAttribute("description", "");
        presetsElement.setAttribute("shortdescription", "");
        return presetsElement;
    }

    private String getComment() {
        StringBuilder comment = new StringBuilder();
        comment.append("\n");
        comment.append(I18n.tr((String)"This file is generated by EasyPresets plugin.\n", (Object[])new Object[0]));
        comment.append(PLUGIN_HELP_URL);
        comment.append("\n");
        comment.append(I18n.tr((String)"It supports just a few tags and attributes.\n", (Object[])new Object[0]));
        comment.append(I18n.tr((String)"If you want to share your custom tags with other users, please look through the official document.\n", (Object[])new Object[0]));
        for (String url : PRESET_FORMAT_URLS) {
            comment.append(" * ");
            comment.append(url);
            comment.append("\n");
        }
        return comment.toString();
    }

    private Element getGroupElement(Document doc) {
        String name = this.getLocaleName();
        return this.getGroupElement(doc, name);
    }

    private Element getGroupElement(Document doc, String name) {
        Element groupElement = doc.createElement("group");
        if (name != null) {
            groupElement.setAttribute("name", name);
        } else {
            groupElement.setAttribute("name", I18n.tr((String)"Custom Presets", (Object[])new Object[0]));
        }
        List<PresetsEntry> list = this.getEntry();
        for (PresetsEntry preset : list) {
            Element itemElement;
            if (preset instanceof EasyPreset) {
                itemElement = ((EasyPreset)preset).getItemElement(doc);
                groupElement.appendChild(itemElement);
            }
            if (preset instanceof EasySeparator) {
                itemElement = ((EasySeparator)preset).getItemElement(doc);
                groupElement.appendChild(itemElement);
                continue;
            }
            if (!(preset instanceof EasyPresets) || ((EasyPresets)preset).isEmpty()) continue;
            itemElement = ((EasyPresets)preset).getGroupElement(doc);
            groupElement.appendChild(itemElement);
        }
        return groupElement;
    }

    public void moveDown(int index) {
        if (index >= this.getSize() - 1) {
            return;
        }
        PresetsEntry presetToMove = (PresetsEntry)this.remove(index);
        this.add(index + 1, presetToMove);
    }

    public void moveUp(int index) {
        if (index <= 0) {
            return;
        }
        PresetsEntry presetToMove = (PresetsEntry)this.remove(index);
        this.add(index - 1, presetToMove);
    }

    public String getLabelFromExistingPresets(String key) {
        Collection existingPresets = TaggingPresets.getTaggingPresets();
        HashMap<String, Integer> labelCountMap = new HashMap<String, Integer>();
        for (TaggingPreset preset : existingPresets) {
            for (TaggingPresetItem _item : preset.data) {
                String label;
                if (!(_item instanceof KeyedItem)) continue;
                KeyedItem item = (KeyedItem)_item;
                if (!key.equals(item.key) || (label = this.getLocaleLabel(item)) == null || label.isEmpty() || label.equals(key)) continue;
                int count = labelCountMap.containsKey(label) ? (Integer)labelCountMap.get(label) + 1 : 1;
                labelCountMap.put(label, count);
            }
        }
        int maxCount = 0;
        String mostFrequentLabel = "";
        for (String label : labelCountMap.keySet()) {
            if ((Integer)labelCountMap.get(label) <= maxCount) continue;
            mostFrequentLabel = label;
            maxCount = (Integer)labelCountMap.get(label);
        }
        return mostFrequentLabel;
    }

    private String getLocaleLabel(KeyedItem _item) {
        if (_item instanceof Text) {
            Text item = (Text)_item;
            return item.locale_text != null ? item.locale_text : DummyPresetClass.getLocaleText(item.text, item.text_context);
        }
        if (_item instanceof ComboMultiSelect) {
            ComboMultiSelect item = (ComboMultiSelect)_item;
            return item.locale_text != null ? item.locale_text : DummyPresetClass.getLocaleText(item.text, item.text_context);
        }
        if (_item instanceof Check) {
            Check item = (Check)_item;
            return item.locale_text != null ? item.locale_text : DummyPresetClass.getLocaleText(item.text, item.text_context);
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.pcs.firePropertyChange(EasyPresets.class.getName(), null, this);
    }

    @Override
    public Icon getIcon() {
        ImageProvider img = new ImageProvider("open");
        img.setSize(ImageProvider.ImageSizes.SMALLICON);
        return img.get();
    }

    @Override
    public String getLocaleName() {
        return I18n.tr((String)this.name, (Object[])new Object[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRawName() {
        String locale = "";
        if (this.parent != null) {
            locale = locale + this.parent.getRawName();
        }
        if (!locale.isEmpty()) {
            locale = locale + "/";
        }
        locale = locale + this.getLocaleName();
        return locale;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public PresetsEntry copy() {
        try {
            EasyPresets preset = this.clone();
            preset.name = I18n.tr((String)"Copy of {0}", (Object[])new Object[]{this.name});
            return preset;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public EasyPresets clone() throws CloneNotSupportedException {
        EasyPresets obj = new EasyPresets(this.parent);
        obj.setName(this.getName());
        obj.parent = this.parent;
        List<PresetsEntry> entries = this.getEntry();
        for (PresetsEntry entry : entries) {
            if (entry instanceof EasyPreset) {
                obj.addElement(((EasyPreset)entry).clone());
                continue;
            }
            if (entry instanceof EasySeparator) {
                obj.addElement(((EasySeparator)entry).clone());
                continue;
            }
            if (!(entry instanceof EasyPresets)) continue;
            obj.addElement(((EasyPresets)entry).clone());
        }
        return obj;
    }

    @Override
    public void addListDataListener(GroupPresetMenu groupPresetMenu) {
        super.addListDataListener(groupPresetMenu);
    }

    @Override
    public EasyPresets getParent() {
        return this.parent;
    }

    @Override
    public void setParent(EasyPresets parent) {
        this.parent = parent;
    }

    static class DummyPresetClass
    extends Text {
        DummyPresetClass() {
        }

        public static String getLocaleText(String text, String textContext) {
            return DummyPresetClass.getLocaleText((String)text, (String)textContext, null);
        }
    }

    public static interface EasyPresetsListener {
        public void onReload();
    }
}

