/*
 * Decompiled with CFR 0.152.
 */
package org.maripo.josm.easypresets.data;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EnumSet;
import org.maripo.josm.easypresets.data.EasyPresets;
import org.maripo.josm.easypresets.data.PresetsEntry;
import org.maripo.josm.easypresets.ui.GroupPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.Combo;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.Label;
import org.openstreetmap.josm.gui.tagging.presets.items.Link;
import org.openstreetmap.josm.gui.tagging.presets.items.MultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.Text;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EasyPreset
extends TaggingPreset
implements PresetsEntry,
Cloneable {
    private static final long serialVersionUID = -7626914563011340418L;
    private EasyPresets parent = null;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public EasyPreset() {
        this(null, null);
    }

    public EasyPreset(TaggingPreset src, EasyPresets parent) {
        this.parent = parent;
        if (src == null) {
            this.name = I18n.tr((String)"New Preset", (Object[])new Object[0]);
        } else {
            this.name = src.name;
            this.setIcon(src.iconName);
            for (TaggingPresetItem fromItem : src.data) {
                TaggingPresetItem item = EasyPreset.clonePresetTag(fromItem);
                if (item == null) continue;
                this.data.add(item);
            }
            this.types = EnumSet.noneOf(TaggingPresetType.class);
            if (src.types != null) {
                this.types.addAll(src.types);
            }
        }
        this.setDisplayName();
    }

    @Override
    public EasyPreset copy() {
        EasyPreset preset = this.clone();
        preset.name = "Copy of " + this.getRawName();
        preset.locale_name = I18n.tr((String)"Copy of {0}", (Object[])new Object[]{this.getRawName()});
        preset.setDisplayName();
        return preset;
    }

    public EasyPreset clone() {
        EasyPreset obj = null;
        try {
            obj = new EasyPreset((TaggingPreset)super.clone(), this.parent);
        }
        catch (Exception e) {
            Logging.error((Throwable)e);
        }
        return obj;
    }

    private static TaggingPresetItem clonePresetTag(TaggingPresetItem itemFrom) {
        if (itemFrom instanceof Label) {
            Label itemTo = new Label();
            itemTo.text = ((Label)itemFrom).text;
            return itemTo;
        }
        if (itemFrom instanceof Key) {
            Key key = (Key)itemFrom;
            Key itemTo = new Key();
            itemTo.key = key.key;
            itemTo.value = key.value;
            return itemTo;
        }
        if (itemFrom instanceof Text) {
            Text text = (Text)itemFrom;
            Text itemTo = new Text();
            itemTo.text = text.text;
            itemTo.key = text.key;
            itemTo.default_ = text.default_;
            return itemTo;
        }
        if (itemFrom instanceof Combo) {
            Combo combo = (Combo)itemFrom;
            Combo itemTo = new Combo();
            itemTo.text = combo.text;
            itemTo.key = combo.key;
            itemTo.values = combo.values;
            return itemTo;
        }
        if (itemFrom instanceof MultiSelect) {
            MultiSelect multiselect = (MultiSelect)itemFrom;
            MultiSelect itemTo = new MultiSelect();
            itemTo.text = multiselect.text;
            itemTo.key = multiselect.key;
            itemTo.values = multiselect.values;
            return itemTo;
        }
        if (itemFrom instanceof Check) {
            Check key = (Check)itemFrom;
            Check itemTo = new Check();
            itemTo.text = key.text;
            itemTo.key = key.key;
            return itemTo;
        }
        if (itemFrom instanceof Link) {
            Link link = (Link)itemFrom;
            Link itemTo = new Link();
            itemTo.href = link.href;
            return itemTo;
        }
        return null;
    }

    Element getItemElement(Document doc) {
        Element itemElement = doc.createElement("item");
        itemElement.setAttribute("name", this.name);
        if (this.iconName != null && !this.iconName.isEmpty()) {
            itemElement.setAttribute("icon", this.iconName);
        }
        if (this.types != null && this.types.size() > 0) {
            ArrayList<String> typeNames = new ArrayList<String>();
            for (TaggingPresetType type : this.types) {
                typeNames.add(type.getName());
            }
            itemElement.setAttribute("type", String.join((CharSequence)",", typeNames));
        }
        for (TaggingPresetItem item : this.data) {
            Element keyElement;
            Key key;
            if (item instanceof Label) {
                Label label = (Label)item;
                Element labelElement = doc.createElement("label");
                labelElement.setAttribute("text", label.text);
                itemElement.appendChild(labelElement);
                continue;
            }
            if (item instanceof Key) {
                key = (Key)item;
                keyElement = doc.createElement("key");
                keyElement.setAttribute("key", key.key);
                keyElement.setAttribute("value", key.value);
                itemElement.appendChild(keyElement);
                continue;
            }
            if (item instanceof Text) {
                Text text = (Text)item;
                Element textElement = doc.createElement("text");
                textElement.setAttribute("text", text.text);
                textElement.setAttribute("key", text.key);
                textElement.setAttribute("default", text.default_);
                itemElement.appendChild(textElement);
                continue;
            }
            if (item instanceof Combo) {
                Combo combo = (Combo)item;
                Element comboElement = doc.createElement("combo");
                comboElement.setAttribute("text", combo.text);
                comboElement.setAttribute("key", combo.key);
                comboElement.setAttribute("values", combo.values);
                itemElement.appendChild(comboElement);
                continue;
            }
            if (item instanceof MultiSelect) {
                MultiSelect multiselect = (MultiSelect)item;
                Element multiselectElement = doc.createElement("multiselect");
                multiselectElement.setAttribute("text", multiselect.text);
                multiselectElement.setAttribute("key", multiselect.key);
                multiselectElement.setAttribute("values", multiselect.values);
                itemElement.appendChild(multiselectElement);
                continue;
            }
            if (item instanceof Check) {
                key = (Check)item;
                keyElement = doc.createElement("check");
                keyElement.setAttribute("text", key.text);
                keyElement.setAttribute("key", key.key);
                itemElement.appendChild(keyElement);
                continue;
            }
            if (!(item instanceof Link)) continue;
            Link link = (Link)item;
            Element linkItem = doc.createElement("link");
            linkItem.setAttribute("href", link.href);
            itemElement.appendChild(linkItem);
        }
        return itemElement;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public EasyPresets getParent() {
        return this.parent;
    }

    @Override
    public void setParent(EasyPresets parent) {
        this.parent = parent;
    }

    @Override
    public synchronized void addListDataListener(GroupPresetMenu groupPresetMenu) {
        System.out.println("EasyPreset.addListDataListener(...)");
    }
}

