// License: Apache 2.0. For details, see LICENSE file.
package org.openstreetmap.josm.plugins.wkt;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;

import static org.openstreetmap.josm.tools.I18n.tr;

/**
 * WKT server reader.  
 * Modified version of geojson plugin. Thanks to the geojson author:
 * @author Omar Vega Ramos &lt;ovruni@riseup.net&gt;
 */
public class WktServerReader extends OsmServerReader {

    private final String url;

    public WktServerReader(String url) {
        this.url = url;
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(tr("Contacting Server…"), 10);
            return new WktFileImporter().parseDataSet(url);
        } catch (Exception e) {
            throw new OsmTransferException(e);
        } finally {
            progressMonitor.finishTask();
        }        
    }
}
