// License: Apache 2.0. For details, see LICENSE file.
package org.openstreetmap.josm.plugins.wkt;

import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

/**
 * Main class for the WKT plugin.
 *
 * Modified version of geojson plugin. Thanks to the authors of geojson plugin: 
 * @author Ian Dees &lt;ian.dees@gmail.com&gt;
 * @author matthieun &lt;https://github.com/matthieun&gt;
 */
public class WktPlugin extends Plugin {
    private final WktFileImporter wktFileImporter;

    public WktPlugin(final PluginInformation info) {
        super(info);
        this.wktFileImporter = new WktFileImporter();
        ExtensionFileFilter.addImporter(this.wktFileImporter);
        ExtensionFileFilter.updateAllFormatsImporter();
        MainApplication.getMenu().openLocation.addDownloadTaskClass(WktDownloadTask.class);
    }
}
