package org.openstreetmap.josm.plugins.UnitScale;

import org.openstreetmap.josm.data.SystemOfMeasurement;

import java.io.Serializable;
    
public class SystemSerializer implements Serializable {
    public String systemName;
    
    public String lengthName;
    public double lengthValue;
    
    public String longLengthName;
    public double longLengthValue;
    
    public String speedName;
    public double speedValue;
    
    public String areaName;
    public double areaValue;
    
    public double negativeZeroToOne(double nz) {
        if (nz > 0) {
            return nz;
        } else {
            return 1;
        }
    }
    
    public SystemSerializer(SystemOfMeasurement system) {
        systemName = system.getName();
        
        lengthName = system.aName;
        lengthValue = negativeZeroToOne(system.aValue);
        
        longLengthName = system.bName;
        longLengthValue = negativeZeroToOne(system.bValue);
        
        speedName = system.speedName;
        speedValue = negativeZeroToOne(system.speedValue);
        
        areaName = system.areaCustomName;
        areaValue = negativeZeroToOne(system.areaCustomValue);
    }
    
    public SystemOfMeasurement toSoM() {
        return new SystemOfMeasurement(systemName,
            lengthValue, lengthName,
            longLengthValue, longLengthName,
            speedName, speedValue,
            areaValue, areaName);
    }
}

