package org.openstreetmap.josm.plugins.UnitScale;

import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;

public class UnitScalePlugin extends Plugin {
    public UnitScalePlugin(PluginInformation info) {
         super(info);
         // add the menu item
         MainMenu.add(MainApplication.getMenu().dataMenu, new UnitScaleAction(), false, 0);
         
         // auto scaling thing
         MainApplication.getLayerManager().addLayerChangeListener(new UnitScaleLayerListener());
         
         UnitScaleUnitManager.load();
    }
    
    @Override
    public PreferenceSetting getPreferenceSetting() {
        return new UnitScalePreferences();
    } 
}
