package org.openstreetmap.josm.plugins.UnitScale;

import static org.openstreetmap.josm.tools.I18n.tr;

import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.MainApplication;

import javax.swing.JOptionPane;

public class UnitScaleLayerListener implements LayerManager.LayerChangeListener {
    public int osmLayers = 0;

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (e.getAddedLayer() instanceof OsmDataLayer) {
            double target = ((OsmDataLayer)e.getAddedLayer()).data.getScale();
            if (osmLayers > 0 && target != UnitScaleCommon.currentScale) {
                Object[] options = {tr("Keep current scale"), tr("Use new scale")};
                int n = JOptionPane.showOptionDialog(MainApplication.getMainFrame(),
                    tr("Added layer has a different scale ({0}) than the current scale ({1})", target, UnitScaleCommon.currentScale),
                    tr("Layer scale difference"),
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.WARNING_MESSAGE,
                    null,
                    options,
                    options[0]);
                if (n == 1) {
                    UnitScaleCommon.scaleToAbsolute(target);
                }
            } else {
                UnitScaleCommon.scaleToAbsolute(target);
            }
            osmLayers++;
        }
    }
    
    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof OsmDataLayer) {
            osmLayers--;
        }
    }
    
    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {}
}

