package org.openstreetmap.josm.plugins.UnitScale;

import static org.openstreetmap.josm.tools.I18n.tr;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.gui.MainApplication;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ButtonGroup;
import javax.swing.BoxLayout;

public class UnitScaleDialog extends JDialog implements ActionListener {
    private double scale = 1;
    private JTextField scaleField;
    private JDialog dialog;
    private JRadioButton radiusButton;
    private JRadioButton absButton;
    
    public UnitScaleDialog(String name) {
        JPanel panel = CreatePanel();
        ShowDialog(panel, name);
    }
    
    public void ShowDialog(JPanel content, String name) {
        dialog = new JDialog(MainApplication.getMainFrame(), name, true);
        
        dialog.add(content);
        dialog.setSize(new Dimension(300, 175));
        dialog.setLocation(new Point(300, 500));
        dialog.setVisible(true);
    }
    
    public JPanel CreatePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
        scaleField = new JTextField(Double.toString(UnitScaleCommon.currentScale), 10);
        panel.add(scaleField);
        
        JPanel axisPanel = new JPanel();
        ButtonGroup axisGroup = new ButtonGroup();
        JRadioButton circumButton = new JRadioButton(tr("Circumference"), true);
        radiusButton = new JRadioButton(tr("Radius"));
        
        axisGroup.add(circumButton);
        axisGroup.add(radiusButton);
        
        axisPanel.add(circumButton);
        axisPanel.add(radiusButton);
        
        panel.add(axisPanel);
        
        
        JPanel relPanel = new JPanel();
        ButtonGroup relGroup = new ButtonGroup();
        JRadioButton relButton = new JRadioButton(tr("Relative to Earth"), true);
        absButton = new JRadioButton(tr("Absolute (kilometers)"));
        
        relGroup.add(relButton);
        relGroup.add(absButton);
        
        relPanel.add(relButton);
        relPanel.add(absButton);
        
        panel.add(relPanel);
        
        
        JPanel confirmPanel = new JPanel();
        
        JButton okButton = new JButton(tr("OK"), ImageProvider.get("ok"));
        confirmPanel.add(okButton);
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        
        JButton cancelButton = new JButton(tr("Cancel"), ImageProvider.get("cancel"));
        confirmPanel.add(cancelButton);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        
        panel.add(confirmPanel);
        
        return panel;
    }
    
    public void ChangeScale() {
        boolean absolute = absButton.isSelected();
        boolean radius = radiusButton.isSelected();
        scale = Double.parseDouble(scaleField.getText());
        if (scale > 0) {
            UnitScaleCommon.scaleToMeasure(scale, absolute, radius);
            UnitScaleCommon.autoSaveToLayer(scale);
        }
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            ChangeScale();
            dialog.dispose();
        } else if ("cancel".equals(e.getActionCommand())) {
            dialog.dispose();
        }
    }
}

