package org.openstreetmap.josm.plugins.UnitScale;

import static org.openstreetmap.josm.tools.I18n.tr;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.Shortcut;

public class UnitScaleAction extends JosmAction {
    public UnitScaleAction() {
        super(tr("Scale units"), "distribute", tr("Scales units to planet size"),
            Shortcut.registerShortcut("tools:UnitScale", tr("Tool: Scale units"), KeyEvent.VK_U, Shortcut.ALT_SHIFT), false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new UnitScaleDialog(tr("Scale planet"));
    }
}

