import urllib.request, json 

def main():
    key = 'shop'
    banned = ['no', 'yes']
    with urllib.request.urlopen('https://taginfo.openstreetmap.org/api/4/key/values?key=' + key + '&sortname=count&sortorder=desc') as url:
        data = json.loads(url.read().decode())
        data = data["data"]
        #print(data[0])
        # Get an array of values that only includes values with more than min_count() occurrences
        counted = [x["value"] for x in data if x["count"] > min_count()]

        print('<?xml version="1.0" encoding="UTF-8"?> <osm version="0.6">')
        index = 0
        for value in counted:
            if value in banned:
                continue
            lat = 50 + int(index/10) * 0.00001
            lon = 20 + index % 10 * 0.00001
            print('<node id="-' + str(index+1) + '" lat="' + str(lat) + '" lon="' + str(lon) + '"><tag k="' + key + '" v="' + value + '"/></node>')
            index += 1
        print('</osm>')

def min_count():
    return 1000

main()