#!/usr/bin/env python3
import os
import glob
import xml.etree.ElementTree as ET

directories = ["report-junit4", "report-junit5"]

def status(directory, filename):
        tree = ET.parse(os.path.join(directory, filename))
        root = tree.getroot()
        try:
            name = root.attrib['name']
        except KeyError as e:
            print(filename)
            print(root.attrib)
            raise e
        tests = {}
        for key in ['tests', 'errors', 'failures', 'skipped', 'aborted']:
            if key in root.attrib and int(root.attrib[key]) > 0:
                tests[key] = root.attrib[key]
        return tests

def compare(filename):
    rname = filename
    if "TEST" not in filename and ".xml" not in filename:
        rname = "TEST-{}.xml".format(filename)
    tstatus = []
    for directory in directories:
        tstatus.append(status(directory, rname))
    return tstatus[0] == tstatus[1]

if __name__ == "__main__":
    files = glob.glob(os.path.join(directories[0], 'TEST*.xml'))
    files = [os.path.basename(x) for x in files]
    files = [x for x in files if x not in ["TESTS-TestSuites.xml"]]
    for filename in files:
        if not compare(filename):
            print(filename)
            for i in directories:
                print("{}: {}".format(i, status(i, filename)))
