//License: GPL. Copyright 2007 by Immanuel Scholz and others
package org.openstreetmap.josm.actions;

import static org.openstreetmap.josm.tools.I18n.tr;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Map.Entry;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TigerUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Pair;


/**
 * Merge two or more nodes into one node - variant that uses the other node.
 * (based on MergeNodesAction)
 *
 * @author Henry Loenwind, based on work of Matthew Newton
 *
 */
public class MergeNodes2Action extends MergeNodesAction implements SelectionChangedListener {

	public MergeNodes2Action() {
		super(tr("Merge Nodes (2)"), "mergenodes", tr("Merge nodes into the newest one."), 0, 0, true);
		DataSet.selListeners.add(this);
	}

	public void actionPerformed(ActionEvent event) {
		Collection<OsmPrimitive> selection = Main.ds.getSelected();
		LinkedList<Node> selectedNodes = new LinkedList<Node>();
		Node useNode = null;

		// the selection check should stop this procedure starting if
		// nothing but node are selected - otherwise we don't care
		// anyway as long as we have at least two nodes
		for (OsmPrimitive osm : selection)
			if (osm instanceof Node){
				selectedNodes.add((Node)osm);
				useNode = (Node)osm;
			}

		if (selectedNodes.size() < 2) {
			JOptionPane.showMessageDialog(Main.parent, tr("Please select at least two nodes to merge."));
			return;
		}

		mergeNodes(selectedNodes, useNode);
	}

}
