package javabug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JI9049427 {

    public static void main(String[] args) throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(
                Runtime.getRuntime().availableProcessors(), newThreadFactory("main-init-%d", Thread.NORM_PRIORITY));
        service.submit(JI9049427::initializeOpeningHoursTest);
        service.submit(JI9049427::initializeOverpassTurboQueryWizard);
        service.shutdown();
        service.awaitTermination(5, TimeUnit.MINUTES);
    }

    static ThreadFactory newThreadFactory(final String nameFormat, final int threadPriority) {
        return new ThreadFactory() {
            final AtomicLong count = new AtomicLong(0);
            @Override
            public Thread newThread(final Runnable runnable) {
                final Thread thread = new Thread(runnable, String.format(Locale.ENGLISH, nameFormat, count.getAndIncrement()));
                thread.setPriority(threadPriority);
                return thread;
            }
        };
    }

    static void initializeOpeningHoursTest() {
        final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");
        try (InputStream cf = JI9049427.class.getResourceAsStream("/opening_hours.js.txt");
            Reader reader = new BufferedReader(new InputStreamReader(cf))) {
                ENGINE.eval(reader);
                ENGINE.eval("var opening_hours = require('opening_hours');");
                // fake country/state to not get errors on holidays
                ENGINE.eval("var nominatimJSON = {address: {state: 'Bayern', country_code: 'de'}};");
                ENGINE.eval(
                    "var oh = function (value, mode, locale) {" +
                    " try {" +
                    "    var r = new opening_hours(value, nominatimJSON, {mode: mode, locale: locale});" +
                    "    r.getErrors = function() {return [];};" +
                    "    return r;" +
                    "  } catch (err) {" +
                    "    return {" +
                    "      prettifyValue: function() {return null;}," +
                    "      getWarnings: function() {return [];}," +
                    "      getErrors: function() {return [err.toString()]}" +
                    "    };" +
                    "  }" +
                    "};");
                System.out.println("OpeningHoursTest OK");
        } catch (IOException | ScriptException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to initialize OpeningHoursTest", e);
        }
    }
    
    static void initializeOverpassTurboQueryWizard() {
        final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");
        try (InputStream cf = JI9049427.class.getResourceAsStream("/overpass-wizard.js.txt");
             Reader reader = new BufferedReader(new InputStreamReader(cf))) {
            ENGINE.eval("var global = {};");
            ENGINE.eval(reader);
            ENGINE.eval("var overpassWizard = function(query) {" +
                    "  return global.overpassWizard(query, {" +
                    "    comment: false," +
                    "    outputFormat: 'xml'," +
                    "    outputMode: 'recursive_meta'" +
                    "  });" +
                    "}");
            System.out.println("OverpassTurboQueryWizard OK");
        } catch (ScriptException | IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to initialize OverpassTurboQueryWizard", e);
        }
    }
}
