// License: GPL. For details, see LICENSE file.
package org.openstreetmap.josm.gui.layer.geoimage;

import static org.openstreetmap.josm.tools.I18n.tr;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JFileChooser;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.Layer.LayerAction;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.tools.ImageProvider;

/**
 * Choose the app to be used as the external image viewer.
 * @since
 */
public class SetExternalViewerAction extends AbstractAction implements LayerAction {

    private final transient GeoImageLayer layer;

    /**
     * Constructs a new {@code SetExternalViewerAction} action.
     * @param layer image layer
     */
    public SetExternalViewerAction(GeoImageLayer layer) {
        super(tr("Set external viewer"), ImageProvider.get("dialogs/next"));
        putValue(SHORT_DESCRIPTION, tr("Choose the application to be used as the external image viewer."));
        this.layer = layer;
    }

    /**
     * This is called after the menu entry was selected.
     * @param arg0 action event
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        AbstractFileChooser fc = new FileChooserManager(true, "external.viewer.lastdirectory", "").
                createFileChooser(false, "Choose the external image viewer", null, JFileChooser.FILES_ONLY).openFileChooser();
        if (fc != null) {
            File sel = fc.getSelectedFile();
            if (sel != null) {
                Main.pref.put("external.viewer.path", sel.toString());
            }
        }
    }

    /** Create actual menu entry. */
    @Override
    public Component createMenuComponent() {
        JMenuItem item = new JMenuItem(this);
        return item;
    }

    /** Check if the current layer is supported. */
    @Override
    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof GeoImageLayer;
    }
}
